/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.controller.organizational;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.RequiresDataAccess;
import org.hswebframework.web.commons.entity.param.QueryParamEntity;
import org.hswebframework.web.controller.SimpleGenericEntityController;
import org.hswebframework.web.controller.message.ResponseMessage;
import org.hswebframework.web.entity.organizational.OrganizationalEntity;
import org.hswebframework.web.service.organizational.OrganizationalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${hsweb.web.mappings.organizational:organizational}"})
@Authorize(permission={"organizational"}, description={"\u673a\u6784\u7ba1\u7406"}, dataAccess=@RequiresDataAccess)
@Api(value="\u673a\u6784\u7ba1\u7406", tags={"\u7ec4\u7ec7\u67b6\u6784-\u673a\u6784\u7ba1\u7406"})
public class OrganizationalController
implements SimpleGenericEntityController<OrganizationalEntity, String, QueryParamEntity> {
    private OrganizationalService organizationalService;

    @Autowired
    public void setOrganizationalService(OrganizationalService organizationalService) {
        this.organizationalService = organizationalService;
    }

    public OrganizationalService getService() {
        return this.organizationalService;
    }

    @PatchMapping(value={"/batch"})
    @Authorize(action={"update"})
    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u6570\u636e")
    public ResponseMessage<Void> updateBatch(@RequestBody List<OrganizationalEntity> batch) {
        this.organizationalService.updateBatch(batch);
        return ResponseMessage.ok();
    }

    @PutMapping(value={"/{id}/disable"})
    @Authorize(action={"disable"})
    @ApiOperation(value="\u7981\u7528\u673a\u6784")
    public ResponseMessage<Boolean> disable(@PathVariable String id) {
        this.organizationalService.disable(id);
        return ResponseMessage.ok();
    }

    @PutMapping(value={"/{id}/enable"})
    @Authorize(action={"enable"})
    @ApiOperation(value="\u542f\u7528\u673a\u6784")
    public ResponseMessage<Boolean> enable(@PathVariable String id) {
        this.organizationalService.enable(id);
        return ResponseMessage.ok();
    }
}

