/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.controller.organizational;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.commons.entity.param.QueryParamEntity;
import org.hswebframework.web.controller.SimpleGenericEntityController;
import org.hswebframework.web.controller.message.ResponseMessage;
import org.hswebframework.web.entity.organizational.DistrictEntity;
import org.hswebframework.web.service.organizational.DistrictService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${hsweb.web.mappings.district:district}"})
@Authorize(permission={"district"}, description={"\u884c\u653f\u533a\u5212\u7ba1\u7406"})
@Api(value="\u884c\u653f\u533a\u5212\u7ba1\u7406", tags={"\u7ec4\u7ec7\u67b6\u6784-\u884c\u653f\u533a\u5212\u7ba1\u7406"})
public class DistrictController
implements SimpleGenericEntityController<DistrictEntity, String, QueryParamEntity> {
    private DistrictService districtService;

    @Autowired
    public void setDistrictService(DistrictService districtService) {
        this.districtService = districtService;
    }

    public DistrictService getService() {
        return this.districtService;
    }

    @GetMapping(value={"/code/{code}"})
    @Authorize(action={"query"})
    @ApiOperation(value="\u6839\u636e\u884c\u653f\u533a\u5212\u4ee3\u7801\u83b7\u53d6")
    public ResponseMessage<DistrictEntity> getByCode(@PathVariable String code) {
        return ResponseMessage.ok((Object)this.districtService.selectByCode(code));
    }

    @GetMapping(value={"/children/{parentId}"})
    @Authorize(action={"query"})
    @ApiOperation(value="\u83b7\u53d6\u5b50\u7ea7\u884c\u653f\u533a\u5212")
    public ResponseMessage<List<DistrictEntity>> getByParentId(@PathVariable String parentId) {
        return ResponseMessage.ok((Object)this.districtService.selectChildNode((Object)parentId));
    }

    @GetMapping(value={"/children/{parentId}/all"})
    @Authorize(action={"query"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u5b50\u7ea7\u884c\u653f\u533a\u5212")
    public ResponseMessage<List<DistrictEntity>> getAllByParentId(@PathVariable String parentId) {
        return ResponseMessage.ok((Object)this.districtService.selectAllChildNode((Object)parentId));
    }

    @GetMapping(value={"/all"})
    @Authorize(action={"query"})
    @ApiOperation(value="\u83b7\u53d6\u5168\u90e8\u884c\u653f\u533a\u5212")
    public ResponseMessage<List<DistrictEntity>> all() {
        return ResponseMessage.ok((Object)this.districtService.select());
    }

    @PatchMapping(value={"/batch"})
    @Authorize(action={"update"})
    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u6570\u636e")
    public ResponseMessage<Void> updateBatch(@RequestBody List<DistrictEntity> batch) {
        this.districtService.updateBatch(batch);
        return ResponseMessage.ok();
    }

    @PutMapping(value={"/{id}/disable"})
    @Authorize(action={"disable"})
    @ApiOperation(value="\u7981\u7528\u884c\u653f\u533a\u5212")
    public ResponseMessage<Boolean> disable(@PathVariable String id) {
        this.districtService.disable(id);
        return ResponseMessage.ok();
    }

    @PutMapping(value={"/{id}/enable"})
    @Authorize(action={"enable"})
    @ApiOperation(value="\u542f\u7528\u884c\u653f\u533a\u5212")
    public ResponseMessage<Boolean> enable(@PathVariable String id) {
        this.districtService.enable(id);
        return ResponseMessage.ok();
    }
}

