/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.organizational.simple.relations;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.hswebframework.web.commons.entity.GenericEntity;
import org.hswebframework.web.organizational.authorization.relation.DepartmentRelations;
import org.hswebframework.web.organizational.authorization.relation.LinkedRelations;
import org.hswebframework.web.organizational.authorization.relation.OrgRelations;
import org.hswebframework.web.organizational.authorization.relation.PersonRelations;
import org.hswebframework.web.organizational.authorization.relation.RelationsManager;
import org.hswebframework.web.service.organizational.simple.relations.DefaultDepartmentRelations;
import org.hswebframework.web.service.organizational.simple.relations.DefaultLinkedRelations;
import org.hswebframework.web.service.organizational.simple.relations.DefaultOrgRelations;
import org.hswebframework.web.service.organizational.simple.relations.DefaultPersonRelations;
import org.hswebframework.web.service.organizational.simple.relations.ServiceContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultRelationsManager
implements RelationsManager {
    @Autowired
    private ServiceContext context;

    public PersonRelations getPersonRelationsByPersonId(String personId) {
        return new DefaultPersonRelations(this.context, () -> Collections.singletonList(personId));
    }

    public PersonRelations getPersonRelationsByUserId(String userId) {
        return new DefaultPersonRelations(this.context, () -> Optional.ofNullable(this.context.getPersonService().selectByUserId(userId)).map(GenericEntity::getId).map(Collections::singletonList).orElseGet(Collections::emptyList));
    }

    public DepartmentRelations getDepartmentRelations(List<String> departmentIds) {
        return new DefaultDepartmentRelations(this.context, () -> departmentIds);
    }

    public OrgRelations getOrgRelations(List<String> orgIds) {
        return new DefaultOrgRelations(this.context, () -> orgIds);
    }

    public LinkedRelations getRelations(List<String> target) {
        return new DefaultLinkedRelations(this.context, () -> target);
    }
}

