/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.organizational.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.web.BusinessException;
import org.hswebframework.web.commons.entity.GenericEntity;
import org.hswebframework.web.commons.entity.TreeSortSupportEntity;
import org.hswebframework.web.dao.dynamic.QueryByEntityDao;
import org.hswebframework.web.dao.organizational.DepartmentDao;
import org.hswebframework.web.dao.organizational.PositionDao;
import org.hswebframework.web.entity.organizational.DepartmentEntity;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.service.DefaultDSLQueryService;
import org.hswebframework.web.service.EnableCacheAllEvictTreeSortService;
import org.hswebframework.web.service.organizational.DepartmentService;
import org.hswebframework.web.service.organizational.OrganizationalService;
import org.hswebframework.web.service.organizational.event.ClearPersonCacheEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service(value="departmentService")
@CacheConfig(cacheNames={"department"})
public class SimpleDepartmentService
extends EnableCacheAllEvictTreeSortService<DepartmentEntity, String>
implements DepartmentService {
    @Autowired
    private DepartmentDao departmentDao;
    @Autowired
    protected PositionDao positionDao;
    @Autowired
    private ApplicationEventPublisher publisher;
    @Autowired
    private OrganizationalService organizationalService;

    public DepartmentDao getDao() {
        return this.departmentDao;
    }

    protected IDGenerator<String> getIDGenerator() {
        return IDGenerator.MD5;
    }

    @Cacheable(key="'org-id:'+#orgId")
    public List<DepartmentEntity> selectByOrgId(String orgId) {
        return ((Query)this.createQuery().where("orgId", (Object)orgId)).listNoPaging();
    }

    @Cacheable(key="'org-ids:'+#orgId==null?0:orgId.hashCode()+'_'+#children+'_'+#parent")
    public List<DepartmentEntity> selectByOrgIds(List<String> orgId, boolean children, boolean parent) {
        if (CollectionUtils.isEmpty(orgId)) {
            return new ArrayList<DepartmentEntity>();
        }
        HashSet<String> allOrgId = new HashSet<String>(orgId);
        if (children) {
            allOrgId.addAll(orgId.stream().map(arg_0 -> ((OrganizationalService)this.organizationalService).selectAllChildNode(arg_0)).flatMap(Collection::stream).map(GenericEntity::getId).collect(Collectors.toSet()));
        }
        if (parent) {
            allOrgId.addAll(orgId.stream().map(arg_0 -> ((OrganizationalService)this.organizationalService).selectParentNode(arg_0)).flatMap(Collection::stream).map(GenericEntity::getId).collect(Collectors.toSet()));
        }
        return ((Query)((Query)this.createQuery().where()).in("orgId", allOrgId)).listNoPaging();
    }

    @Cacheable(key="'name:'+#name")
    public List<DepartmentEntity> selectByName(String name) {
        return ((Query)this.createQuery().where("name", (Object)name)).listNoPaging();
    }

    @Cacheable(key="'code:'+#code")
    public DepartmentEntity selectByCode(String code) {
        return (DepartmentEntity)((Query)this.createQuery().where("code", (Object)code)).single();
    }

    public DepartmentEntity deleteByPk(String id) {
        if (((Query)DefaultDSLQueryService.createQuery((QueryByEntityDao)this.positionDao).where("departmentId", (Object)id)).total() > 0) {
            throw new BusinessException("\u90e8\u95e8\u4e0b\u5b58\u5728\u804c\u4f4d\u4fe1\u606f,\u65e0\u6cd5\u5220\u9664!");
        }
        this.publisher.publishEvent((Object)new ClearPersonCacheEvent());
        return (DepartmentEntity)super.deleteByPk((Object)id);
    }

    public String insert(DepartmentEntity entity) {
        this.publisher.publishEvent((Object)new ClearPersonCacheEvent());
        return (String)super.insert((TreeSortSupportEntity)entity);
    }

    public int updateByPk(String id, DepartmentEntity entity) {
        this.publisher.publishEvent((Object)new ClearPersonCacheEvent());
        return super.updateByPk((Object)id, (TreeSortSupportEntity)entity);
    }
}

