/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.organizational.simple;

import java.util.Objects;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.ezorm.core.dsl.Update;
import org.hswebframework.web.BusinessException;
import org.hswebframework.web.commons.entity.DataStatus;
import org.hswebframework.web.commons.entity.TreeSortSupportEntity;
import org.hswebframework.web.dao.dynamic.QueryByEntityDao;
import org.hswebframework.web.dao.organizational.DepartmentDao;
import org.hswebframework.web.dao.organizational.OrganizationalDao;
import org.hswebframework.web.entity.organizational.OrganizationalEntity;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.service.DefaultDSLQueryService;
import org.hswebframework.web.service.EnableCacheAllEvictTreeSortService;
import org.hswebframework.web.service.organizational.OrganizationalService;
import org.hswebframework.web.service.organizational.event.ClearPersonCacheEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service(value="organizationalService")
@CacheConfig(cacheNames={"organizational"})
public class SimpleOrganizationalService
extends EnableCacheAllEvictTreeSortService<OrganizationalEntity, String>
implements OrganizationalService {
    @Autowired
    private OrganizationalDao organizationalDao;
    @Autowired
    private DepartmentDao departmentDao;
    @Autowired
    private ApplicationEventPublisher publisher;

    public OrganizationalDao getDao() {
        return this.organizationalDao;
    }

    protected IDGenerator<String> getIDGenerator() {
        return IDGenerator.MD5;
    }

    @CacheEvict(allEntries=true)
    public OrganizationalEntity deleteByPk(String id) {
        if (((Query)DefaultDSLQueryService.createQuery((QueryByEntityDao)this.departmentDao).where("orgId", (Object)id)).total() > 0) {
            throw new BusinessException("\u673a\u6784\u4e0b\u5b58\u5728\u90e8\u95e8\u4fe1\u606f,\u65e0\u6cd5\u5220\u9664");
        }
        this.publisher.publishEvent((Object)new ClearPersonCacheEvent());
        return (OrganizationalEntity)super.deleteByPk((Object)id);
    }

    @CacheEvict(allEntries=true)
    public String insert(OrganizationalEntity entity) {
        entity.setStatus(DataStatus.STATUS_ENABLED);
        this.publisher.publishEvent((Object)new ClearPersonCacheEvent());
        return (String)super.insert((TreeSortSupportEntity)entity);
    }

    public int updateByPk(String id, OrganizationalEntity entity) {
        this.publisher.publishEvent((Object)new ClearPersonCacheEvent());
        return super.updateByPk((Object)id, (TreeSortSupportEntity)entity);
    }

    @CacheEvict(allEntries=true)
    public void disable(String id) {
        Objects.requireNonNull(id);
        ((Update)this.createUpdate().set("status", (Object)DataStatus.STATUS_DISABLED).where("id", (Object)id)).exec();
        this.publisher.publishEvent((Object)new ClearPersonCacheEvent());
    }

    @CacheEvict(allEntries=true)
    public void enable(String id) {
        Objects.requireNonNull(id);
        ((Update)this.createUpdate().set("status", (Object)DataStatus.STATUS_ENABLED).where("id", (Object)id)).exec();
        this.publisher.publishEvent((Object)new ClearPersonCacheEvent());
    }

    @Transactional(readOnly=true)
    @Cacheable(key="'code:'+#code")
    public OrganizationalEntity selectByCode(String code) {
        if (StringUtils.isEmpty((Object)code)) {
            return null;
        }
        return (OrganizationalEntity)((Query)this.createQuery().where("code", (Object)code)).single();
    }

    @Cacheable(key="'name:'+#name")
    @Transactional(readOnly=true)
    public OrganizationalEntity selectByName(String name) {
        if (StringUtils.isEmpty((Object)name)) {
            return null;
        }
        return (OrganizationalEntity)((Query)this.createQuery().where("name", (Object)name)).single();
    }
}

