/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.organizational.simple;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.ezorm.core.dsl.Update;
import org.hswebframework.web.BusinessException;
import org.hswebframework.web.commons.entity.DataStatus;
import org.hswebframework.web.commons.entity.TreeSortSupportEntity;
import org.hswebframework.web.dao.dynamic.QueryByEntityDao;
import org.hswebframework.web.dao.organizational.DistrictDao;
import org.hswebframework.web.dao.organizational.OrganizationalDao;
import org.hswebframework.web.entity.organizational.DistrictEntity;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.service.DefaultDSLQueryService;
import org.hswebframework.web.service.EnableCacheAllEvictTreeSortService;
import org.hswebframework.web.service.organizational.DistrictService;
import org.hswebframework.web.service.organizational.event.ClearPersonCacheEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service(value="districtService")
@CacheConfig(cacheNames={"district"})
public class SimpleDistrictService
extends EnableCacheAllEvictTreeSortService<DistrictEntity, String>
implements DistrictService {
    @Autowired
    private DistrictDao districtDao;
    @Autowired
    private OrganizationalDao organizationalDao;
    @Autowired
    private ApplicationEventPublisher publisher;

    protected IDGenerator<String> getIDGenerator() {
        return IDGenerator.MD5;
    }

    public DistrictDao getDao() {
        return this.districtDao;
    }

    @CacheEvict(allEntries=true)
    public String insert(DistrictEntity entity) {
        this.publisher.publishEvent((Object)new ClearPersonCacheEvent());
        return (String)super.insert((TreeSortSupportEntity)entity);
    }

    @CacheEvict(allEntries=true)
    public int updateByPk(String id, DistrictEntity entity) {
        this.publisher.publishEvent((Object)new ClearPersonCacheEvent());
        return super.updateByPk((Object)id, (TreeSortSupportEntity)entity);
    }

    @Cacheable(key="'ids:'+(#id==null?0:#id.hashCode())")
    public List<DistrictEntity> selectByPk(List<String> id) {
        return super.selectByPk(id);
    }

    @Cacheable(key="'id:'+#id")
    public DistrictEntity selectByPk(String id) {
        return (DistrictEntity)super.selectByPk((Object)id);
    }

    @CacheEvict(allEntries=true)
    public DistrictEntity deleteByPk(String id) {
        if (((Query)DefaultDSLQueryService.createQuery((QueryByEntityDao)this.organizationalDao).where("districtId", (Object)id)).total() > 0) {
            throw new BusinessException("\u884c\u653f\u533a\u57df\u4e0b\u5b58\u5728\u673a\u6784\u4fe1\u606f,\u65e0\u6cd5\u5220\u9664!");
        }
        this.publisher.publishEvent((Object)new ClearPersonCacheEvent());
        return (DistrictEntity)super.deleteByPk((Object)id);
    }

    @Cacheable(key="'code:'+#code")
    public DistrictEntity selectByCode(String code) {
        return (DistrictEntity)((Query)this.createQuery().where("code", (Object)code)).single();
    }

    @CacheEvict(allEntries=true)
    public int updateBatch(Collection<DistrictEntity> data) {
        return super.updateBatch(data);
    }

    @Cacheable(key="'all'")
    public List<DistrictEntity> select() {
        return ((Query)this.createQuery().where()).orderByAsc("sortIndex").listNoPaging();
    }

    @CacheEvict(allEntries=true)
    public int updateByPk(List<DistrictEntity> data) {
        return super.updateByPk(data);
    }

    @CacheEvict(allEntries=true)
    public void disable(String id) {
        Objects.requireNonNull(id);
        ((Update)this.createUpdate().set("status", (Object)DataStatus.STATUS_DISABLED).where("id", (Object)id)).exec();
        this.publisher.publishEvent((Object)new ClearPersonCacheEvent());
    }

    @CacheEvict(allEntries=true)
    public void enable(String id) {
        Objects.requireNonNull(id);
        ((Update)this.createUpdate().set("status", (Object)DataStatus.STATUS_ENABLED).where("id", (Object)id)).exec();
        this.publisher.publishEvent((Object)new ClearPersonCacheEvent());
    }
}

