/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.organizational.simple.terms;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.rdb.render.SqlAppender;
import org.hswebframework.ezorm.rdb.render.dialect.Dialect;
import org.hswebframework.ezorm.rdb.render.dialect.RenderPhase;
import org.hswebframework.ezorm.rdb.render.dialect.function.SqlFunction;
import org.hswebframework.web.commons.entity.TreeSupportEntity;
import org.hswebframework.web.dao.mybatis.mapper.AbstractSqlTermCustomizer;
import org.hswebframework.web.datasource.DataSourceHolder;
import org.hswebframework.web.service.QueryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UserInSqlTerm<PK>
extends AbstractSqlTermCustomizer {
    private static final Logger log = LoggerFactory.getLogger(UserInSqlTerm.class);
    private boolean child;
    private boolean parent;
    private boolean forPerson;
    QueryService<? extends TreeSupportEntity<PK>, PK> treeService;

    public UserInSqlTerm<PK> forChild() {
        this.setChild(true);
        return this;
    }

    public UserInSqlTerm<PK> forParent() {
        this.setParent(true);
        return this;
    }

    public UserInSqlTerm<PK> forPerson() {
        this.forPerson = true;
        return this;
    }

    public UserInSqlTerm(String term, QueryService<? extends TreeSupportEntity<PK>, PK> treeService) {
        super(term);
        this.treeService = treeService;
    }

    public abstract String getTableName();

    protected String getTableFullName(String tableName) {
        String db = DataSourceHolder.databaseSwitcher().currentDatabase();
        if (db != null) {
            return db.concat(".").concat(tableName);
        }
        return tableName;
    }

    protected Object appendCondition(List<Object> values, String wherePrefix, SqlAppender appender, String column, Dialect dialect) {
        if (!this.child && !this.parent) {
            appender.addSpc(new Object[]{column});
            return super.appendCondition(values, wherePrefix, appender);
        }
        List paths = this.getTreePathByTerm(values).stream().map(path -> this.parent ? path : path.concat("%")).collect(Collectors.toList());
        int len = paths.size();
        if (len == 0) {
            appender.add((Object)"1=2");
        } else {
            appender.add((Object)"(");
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    appender.addSpc(new Object[]{"or"});
                }
                if (this.parent) {
                    String concat;
                    SqlFunction function = dialect.getFunction("concat");
                    if (function == null) {
                        concat = this.getTableName() + ".path";
                        log.warn("\u6570\u636e\u5e93\u65b9\u8a00\u672a\u652f\u6301concat\u51fd\u6570,\u4f60\u53ef\u4ee5\u8c03\u7528Dialect.installFunction\u8fdb\u884c\u8bbe\u7f6e!");
                    } else {
                        concat = function.apply(SqlFunction.Param.of((RenderPhase)RenderPhase.where, Arrays.asList(this.getTableName() + ".path", "'%'")));
                    }
                    appender.add(new Object[]{"#{", wherePrefix, ".value.value[", i, "]}", " like ", concat});
                    continue;
                }
                appender.add(new Object[]{this.getTableName(), ".path like #{", wherePrefix, ".value.value[", i, "]}"});
            }
            appender.add((Object)")");
        }
        return paths;
    }

    protected List<String> getTreePathByTerm(List<Object> termValue) {
        List<Object> idList = termValue;
        return this.treeService.selectByPk(idList).stream().map(TreeSupportEntity::getPath).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void setChild(boolean child) {
        this.child = child;
    }

    public boolean isChild() {
        return this.child;
    }

    public boolean isParent() {
        return this.parent;
    }

    public void setParent(boolean parent) {
        this.parent = parent;
    }

    public boolean isForPerson() {
        return this.forPerson;
    }

    public void setForPerson(boolean forPerson) {
        this.forPerson = forPerson;
    }
}

