/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.organizational.simple;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.web.dao.dynamic.QueryByEntityDao;
import org.hswebframework.web.dao.organizational.RelationInfoDao;
import org.hswebframework.web.entity.organizational.RelationInfoEntity;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.organizational.authorization.relation.Relation;
import org.hswebframework.web.organizational.authorization.relation.RelationTargetHolder;
import org.hswebframework.web.organizational.authorization.relation.Relations;
import org.hswebframework.web.organizational.authorization.relation.SimpleRelation;
import org.hswebframework.web.organizational.authorization.relation.SimpleRelations;
import org.hswebframework.web.service.DefaultDSLQueryService;
import org.hswebframework.web.service.GenericEntityService;
import org.hswebframework.web.service.organizational.RelationInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="relationInfoService")
public class SimpleRelationInfoService
extends GenericEntityService<RelationInfoEntity, String>
implements RelationInfoService {
    @Autowired
    private RelationInfoDao relationInfoDao;

    protected IDGenerator<String> getIDGenerator() {
        return IDGenerator.MD5;
    }

    public RelationInfoDao getDao() {
        return this.relationInfoDao;
    }

    public Relations getRelations(String relationTypeFrom, String target) {
        Objects.requireNonNull(relationTypeFrom);
        Objects.requireNonNull(target);
        List relationInfoList = ((Query)((Query)DefaultDSLQueryService.createQuery((QueryByEntityDao)this.relationInfoDao).where("relationTypeFrom", (Object)relationTypeFrom)).nest().is("relationFrom", (Object)target).or("relationTo", (Object)target).end()).listNoPaging();
        List relations = relationInfoList.stream().map(info -> {
            SimpleRelation relation = new SimpleRelation();
            relation.setDimension(info.getRelationTypeFrom());
            relation.setTarget(info.getRelationTo());
            relation.setTargetObject((Serializable)RelationTargetHolder.get((String)info.getRelationTypeTo(), (String)info.getRelationTo()).orElse(null));
            relation.setRelation(info.getRelationId());
            if (target.equals(info.getRelationFrom())) {
                relation.setDirection(Relation.Direction.POSITIVE);
            } else {
                relation.setDirection(Relation.Direction.REVERSE);
            }
            return relation;
        }).collect(Collectors.toList());
        return new SimpleRelations(relations);
    }
}

