/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.organizational.simple.relations;

import io.vavr.Lazy;
import java.io.Serializable;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hswebframework.ezorm.core.NestConditional;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.web.commons.entity.Entity;
import org.hswebframework.web.commons.entity.param.QueryParamEntity;
import org.hswebframework.web.entity.organizational.PersonEntity;
import org.hswebframework.web.organizational.authorization.relation.LinkedRelations;
import org.hswebframework.web.organizational.authorization.relation.Relation;
import org.hswebframework.web.organizational.authorization.relation.RelationTargetHolder;
import org.hswebframework.web.organizational.authorization.relation.SimpleRelation;
import org.hswebframework.web.service.organizational.simple.relations.ServiceContext;

public class DefaultLinkedRelations<C extends LinkedRelations>
implements LinkedRelations<C> {
    protected Supplier<List<String>> targetIdSupplier;
    protected transient NestConditional<Query<PersonEntity, QueryParamEntity>> query;
    protected transient ServiceContext serviceContext;

    public DefaultLinkedRelations(ServiceContext serviceContext, Supplier<List<String>> targetIdSupplier) {
        this.serviceContext = serviceContext;
        this.targetIdSupplier = targetIdSupplier;
        this.query = Query.empty((QueryParam)new QueryParamEntity()).nest();
    }

    public C relations(Relation.Direction direction, String dimension, String relation) {
        switch (direction) {
            case REVERSE: {
                this.query.nest().is("relationTypeTo", (Object)dimension).is("relationId", (Object)relation).end();
                break;
            }
            case POSITIVE: {
                this.query.nest().is("relationTypeFrom", (Object)dimension).is("relationId", (Object)relation).end();
                break;
            }
            case ALL: {
                ((NestConditional)((NestConditional)this.query.nest().nest().is("relationTypeFrom", (Object)dimension).is("relationId", (Object)relation).end()).or().nest().is("relationTypeTo", (Object)dimension).is("relationId", (Object)relation).end()).end();
            }
        }
        return (C)this;
    }

    public C is(String property, Object value) {
        this.query.is(property, value);
        return (C)this;
    }

    public C not(String property, Object value) {
        this.query.not(property, value);
        return (C)this;
    }

    public C or() {
        this.query.or();
        return (C)this;
    }

    public C and() {
        this.query.and();
        return (C)this;
    }

    public Supplier<List<String>> createLazyIdSupplier(Supplier<List<String>> idSupplier) {
        return (Supplier)Lazy.val(() -> {
            List ids = (List)idSupplier.get();
            return () -> ids;
        }, Supplier.class);
    }

    public Stream<Relation> relationStream(Supplier<List<String>> supplier) {
        List<String> personIdList = supplier.get();
        QueryParamEntity queryParamEntity = (QueryParamEntity)((Query)((Query)this.query.end()).and().nest().in("relationFrom", personIdList).or().in("relationTo", personIdList).end()).getParam();
        return this.serviceContext.getRelationInfoService().select((Entity)queryParamEntity).stream().map(info -> {
            SimpleRelation relation = new SimpleRelation();
            relation.setTarget(info.getRelationTo());
            relation.setTargetObject((Serializable)RelationTargetHolder.get((String)info.getRelationTypeTo(), (String)info.getRelationTo()).orElse(null));
            relation.setRelation(info.getRelationId());
            if (personIdList.contains(info.getRelationFrom())) {
                relation.setDimension(info.getRelationTypeFrom());
                relation.setDirection(Relation.Direction.POSITIVE);
            } else {
                relation.setDimension(info.getRelationTypeTo());
                relation.setDirection(Relation.Direction.REVERSE);
            }
            return relation;
        });
    }

    public C deep() {
        if (this.getClass() != DefaultLinkedRelations.class) {
            throw new UnsupportedOperationException("\u5b50\u7c7b\u672a\u5b9e\u73b0deep\u65b9\u6cd5");
        }
        return (C)new DefaultLinkedRelations<C>(this.serviceContext, () -> this.all().stream().map(Relation::getTarget).collect(Collectors.toList()));
    }

    public Stream<Relation> stream() {
        return this.relationStream(this.targetIdSupplier);
    }
}

