/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.organizational.simple.relations;

import io.vavr.Lazy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hswebframework.ezorm.core.NestConditional;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.web.commons.entity.Entity;
import org.hswebframework.web.commons.entity.GenericEntity;
import org.hswebframework.web.commons.entity.param.QueryParamEntity;
import org.hswebframework.web.entity.organizational.DepartmentEntity;
import org.hswebframework.web.entity.organizational.PersonEntity;
import org.hswebframework.web.entity.organizational.PositionEntity;
import org.hswebframework.web.organizational.authorization.relation.DepartmentRelations;
import org.hswebframework.web.organizational.authorization.relation.PersonRelations;
import org.hswebframework.web.organizational.authorization.relation.Relation;
import org.hswebframework.web.organizational.authorization.relation.SimpleRelation;
import org.hswebframework.web.service.organizational.DepartmentService;
import org.hswebframework.web.service.organizational.simple.relations.DefaultLinkedRelations;
import org.hswebframework.web.service.organizational.simple.relations.DefaultPersonRelations;
import org.hswebframework.web.service.organizational.simple.relations.ServiceContext;
import org.springframework.util.CollectionUtils;

public class DefaultDepartmentRelations
extends DefaultLinkedRelations<DepartmentRelations>
implements DepartmentRelations {
    private boolean includeChildren;
    private boolean includeParent;
    private NestConditional<Query<DepartmentEntity, QueryParamEntity>> departmentQuery = Query.empty((QueryParam)new QueryParamEntity()).noPaging().nest();
    private NestConditional<Query<PositionEntity, QueryParamEntity>> positionQuery = Query.empty((QueryParam)new QueryParamEntity()).noPaging().nest();
    private Supplier<List<PositionEntity>> positionSupplier = (Supplier)Lazy.val(() -> {
        List<String> departmentId = this.getAllDepartmentId();
        if (CollectionUtils.isEmpty(departmentId)) {
            return () -> new ArrayList();
        }
        QueryParamEntity positionQueryParam = (QueryParamEntity)((Query)((Query)this.positionQuery.end()).in("departmentId", departmentId)).getParam();
        List positions = this.serviceContext.getPositionService().select((Entity)positionQueryParam).stream().collect(Collectors.toList());
        return () -> positions;
    }, Supplier.class);
    private Supplier<List<String>> allDepartmentId = this.createLazyIdSupplier(() -> {
        QueryParamEntity paramEntity;
        HashSet departmentId = new HashSet((Collection)this.targetIdSupplier.get());
        if (CollectionUtils.isEmpty(departmentId)) {
            return new ArrayList();
        }
        Set allParent = null;
        Set allChildren = null;
        if (this.includeParent) {
            allParent = departmentId.stream().map(arg_0 -> ((DepartmentService)this.serviceContext.getDepartmentService()).selectParentNode(arg_0)).flatMap(Collection::stream).map(GenericEntity::getId).collect(Collectors.toSet());
        }
        if (this.includeChildren) {
            allChildren = departmentId.stream().map(arg_0 -> ((DepartmentService)this.serviceContext.getDepartmentService()).selectAllChildNode(arg_0)).flatMap(Collection::stream).map(GenericEntity::getId).collect(Collectors.toSet());
        }
        if (!CollectionUtils.isEmpty(allChildren)) {
            departmentId.addAll(allChildren);
        }
        if (!CollectionUtils.isEmpty(allParent)) {
            departmentId.addAll(allParent);
        }
        if ((paramEntity = (QueryParamEntity)((Query)this.departmentQuery.end()).getParam()).getTerms().isEmpty()) {
            return new ArrayList(departmentId);
        }
        paramEntity = (QueryParamEntity)((Query)((Query)this.departmentQuery.end()).select(new String[]{"id"}).in("id", departmentId)).getParam();
        return this.serviceContext.getDepartmentService().select((Entity)paramEntity).stream().map(GenericEntity::getId).collect(Collectors.toList());
    });

    public DefaultDepartmentRelations(ServiceContext serviceContext, Supplier<List<String>> targetIdSupplier) {
        super(serviceContext, targetIdSupplier);
    }

    public DepartmentRelations andChildren() {
        this.includeChildren = true;
        return this;
    }

    public DepartmentRelations andParents() {
        this.includeParent = true;
        return this;
    }

    @Override
    public DepartmentRelations relations(Relation.Direction direction, String dimension, String relation) {
        if ((dimension == null || "position".equals(dimension)) && direction != Relation.Direction.REVERSE) {
            this.positionQuery.is("name", (Object)relation);
        }
        return (DepartmentRelations)super.relations(direction, dimension, relation);
    }

    @Override
    public DepartmentRelations or() {
        this.positionQuery.or();
        this.departmentQuery.or();
        return (DepartmentRelations)super.or();
    }

    @Override
    public DepartmentRelations and() {
        this.positionQuery.and();
        this.departmentQuery.and();
        return (DepartmentRelations)super.and();
    }

    @Override
    public DepartmentRelations not(String property, Object value) {
        this.departmentQuery.not(property, value);
        return (DepartmentRelations)super.not(property, value);
    }

    @Override
    public DepartmentRelations is(String property, Object value) {
        this.departmentQuery.is(property, value);
        return (DepartmentRelations)super.is(property, value);
    }

    @Override
    public Stream<Relation> stream() {
        HashMap cache = new HashMap();
        List<PositionEntity> positions = this.positionSupplier.get();
        List positionIdList = this.getAllPerson().stream().map(person -> this.serviceContext.getPersonService().selectAuthBindByPk((String)person.getId())).filter(bin -> !CollectionUtils.isEmpty((Collection)bin.getPositionIds())).flatMap(bind -> bind.getPositionIds().stream().peek(positionId -> cache.computeIfAbsent(positionId, i -> new ArrayList()).add(bind))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(positionIdList)) {
            return super.relationStream(this.allDepartmentId);
        }
        Stream relationStream = positions.stream().flatMap(position -> {
            List personEntities = (List)cache.get(position.getId());
            if (CollectionUtils.isEmpty((Collection)personEntities)) {
                return Stream.empty();
            }
            return personEntities.stream().map(person -> {
                SimpleRelation relation = new SimpleRelation();
                relation.setName(position.getName());
                relation.setTarget((String)person.getId());
                relation.setTargetObject((Serializable)person);
                relation.setDirection(Relation.Direction.REVERSE);
                relation.setDimension("position");
                relation.setRelation((String)position.getId());
                return relation;
            });
        });
        return Stream.concat(relationStream, super.relationStream(this.allDepartmentId));
    }

    public List<String> getAllDepartmentId() {
        return this.allDepartmentId.get();
    }

    public List<PersonEntity> getAllPerson() {
        List<PositionEntity> positionEntities = this.positionSupplier.get();
        if (CollectionUtils.isEmpty(positionEntities)) {
            return new ArrayList<PersonEntity>();
        }
        return this.serviceContext.getPersonService().selectByPositionIds(positionEntities.stream().map(GenericEntity::getId).collect(Collectors.toList()));
    }

    public List<String> getAllUserId() {
        return this.getAllPerson().stream().map(PersonEntity::getUserId).collect(Collectors.toList());
    }

    public List<String> getAllPersonId() {
        return this.getAllPerson().stream().map(GenericEntity::getId).collect(Collectors.toList());
    }

    @Override
    public DepartmentRelations deep() {
        return new DefaultDepartmentRelations(this.serviceContext, this.allDepartmentId);
    }

    public PersonRelations persons() {
        return new DefaultPersonRelations(this.serviceContext, this.createLazyIdSupplier(this::getAllPersonId));
    }
}

