/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.organizational.simple;

import org.hswebframework.web.BusinessException;
import org.hswebframework.web.commons.entity.TreeSortSupportEntity;
import org.hswebframework.web.dao.organizational.PersonDao;
import org.hswebframework.web.dao.organizational.PositionDao;
import org.hswebframework.web.entity.organizational.PositionEntity;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.service.EnableCacheAllEvictTreeSortService;
import org.hswebframework.web.service.organizational.PositionService;
import org.hswebframework.web.service.organizational.event.ClearPersonCacheEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="positionService")
@CacheConfig(cacheNames={"hsweb-position"})
public class SimplePositionService
extends EnableCacheAllEvictTreeSortService<PositionEntity, String>
implements PositionService {
    @Autowired
    private ApplicationEventPublisher publisher;
    @Autowired
    private PositionDao positionDao;
    @Autowired
    private PersonDao personDao;

    public PositionDao getDao() {
        return this.positionDao;
    }

    protected IDGenerator<String> getIDGenerator() {
        return IDGenerator.MD5;
    }

    @CacheEvict(allEntries=true)
    public PositionEntity deleteByPk(String id) {
        if (!CollectionUtils.isEmpty(this.personDao.selectByPositionId(id))) {
            throw new BusinessException("\u5c97\u4f4d\u4e2d\u8fd8\u6709\u4eba\u5458,\u65e0\u6cd5\u5220\u9664!");
        }
        this.publisher.publishEvent((Object)new ClearPersonCacheEvent());
        return (PositionEntity)super.deleteByPk((Object)id);
    }

    @CacheEvict(allEntries=true)
    public int updateByPk(String id, PositionEntity entity) {
        this.publisher.publishEvent((Object)new ClearPersonCacheEvent());
        return super.updateByPk((Object)id, (TreeSortSupportEntity)entity);
    }

    @CacheEvict(allEntries=true)
    public String insert(PositionEntity entity) {
        this.publisher.publishEvent((Object)new ClearPersonCacheEvent());
        return (String)super.insert((TreeSortSupportEntity)entity);
    }
}

