/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.organizational.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.web.commons.entity.DataStatus;
import org.hswebframework.web.commons.entity.GenericEntity;
import org.hswebframework.web.commons.entity.TreeSupportEntity;
import org.hswebframework.web.dao.dynamic.QueryByEntityDao;
import org.hswebframework.web.dao.organizational.DepartmentDao;
import org.hswebframework.web.dao.organizational.DistrictDao;
import org.hswebframework.web.dao.organizational.OrganizationalDao;
import org.hswebframework.web.dao.organizational.PersonDao;
import org.hswebframework.web.dao.organizational.PersonPositionDao;
import org.hswebframework.web.dao.organizational.PositionDao;
import org.hswebframework.web.dao.organizational.RelationInfoDao;
import org.hswebframework.web.entity.authorization.UserEntity;
import org.hswebframework.web.entity.organizational.DepartmentEntity;
import org.hswebframework.web.entity.organizational.DistrictEntity;
import org.hswebframework.web.entity.organizational.OrganizationalEntity;
import org.hswebframework.web.entity.organizational.PersonAuthBindEntity;
import org.hswebframework.web.entity.organizational.PersonEntity;
import org.hswebframework.web.entity.organizational.PersonPositionEntity;
import org.hswebframework.web.entity.organizational.PersonUserEntity;
import org.hswebframework.web.entity.organizational.PositionEntity;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.organizational.authorization.Department;
import org.hswebframework.web.organizational.authorization.District;
import org.hswebframework.web.organizational.authorization.Organization;
import org.hswebframework.web.organizational.authorization.Personnel;
import org.hswebframework.web.organizational.authorization.PersonnelAuthentication;
import org.hswebframework.web.organizational.authorization.PersonnelAuthenticationManager;
import org.hswebframework.web.organizational.authorization.TreeNode;
import org.hswebframework.web.organizational.authorization.access.DepartmentAttachEntity;
import org.hswebframework.web.organizational.authorization.access.DistrictAttachEntity;
import org.hswebframework.web.organizational.authorization.access.OrgAttachEntity;
import org.hswebframework.web.organizational.authorization.access.PositionAttachEntity;
import org.hswebframework.web.organizational.authorization.relation.Relation;
import org.hswebframework.web.organizational.authorization.relation.Relations;
import org.hswebframework.web.organizational.authorization.relation.SimpleRelation;
import org.hswebframework.web.organizational.authorization.relation.SimpleRelations;
import org.hswebframework.web.organizational.authorization.simple.SimpleDepartment;
import org.hswebframework.web.organizational.authorization.simple.SimpleDistrict;
import org.hswebframework.web.organizational.authorization.simple.SimpleOrganization;
import org.hswebframework.web.organizational.authorization.simple.SimplePersonnel;
import org.hswebframework.web.organizational.authorization.simple.SimplePersonnelAuthentication;
import org.hswebframework.web.organizational.authorization.simple.SimplePosition;
import org.hswebframework.web.service.DefaultDSLQueryService;
import org.hswebframework.web.service.GenericEntityService;
import org.hswebframework.web.service.authorization.UserService;
import org.hswebframework.web.service.organizational.PersonService;
import org.hswebframework.web.service.organizational.event.ClearPersonCacheEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.stereotype.Service;
import org.springframework.transaction.event.TransactionalEventListener;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="personService")
@CacheConfig(cacheNames={"person"})
public class SimplePersonService
extends GenericEntityService<PersonEntity, String>
implements PersonService,
PersonnelAuthenticationManager {
    @Autowired
    private PersonDao personDao;
    @Autowired
    private PersonPositionDao personPositionDao;
    @Autowired
    private PositionDao positionDao;
    @Autowired
    private DepartmentDao departmentDao;
    @Autowired
    private OrganizationalDao organizationalDao;
    @Autowired
    private DistrictDao districtDao;
    @Autowired(required=false)
    private UserService userService;
    @Autowired
    private RelationInfoDao relationInfoDao;

    protected IDGenerator<String> getIDGenerator() {
        return IDGenerator.MD5;
    }

    public PersonDao getDao() {
        return this.personDao;
    }

    @Caching(evict={@CacheEvict(key="'id:'+#result"), @CacheEvict(key="'auth:persion-id'+#result"), @CacheEvict(key="'auth:user-id'+#authBindEntity.userId"), @CacheEvict(key="'auth-bind'+#result"), @CacheEvict(key="'person-name'+#authBindEntity.name")})
    public String insert(PersonAuthBindEntity authBindEntity) {
        authBindEntity.setStatus(DataStatus.STATUS_ENABLED);
        if (authBindEntity.getPersonUser() != null) {
            this.syncUserInfo(authBindEntity);
        }
        String id = (String)this.insert((GenericEntity)authBindEntity);
        if (authBindEntity.getPositionIds() != null) {
            this.syncPositionInfo(id, authBindEntity.getPositionIds());
        }
        return id;
    }

    @Caching(evict={@CacheEvict(key="'id:'+#authBindEntity.id"), @CacheEvict(key="'auth:persion-id'+#authBindEntity.id"), @CacheEvict(key="'auth:user-id'+#authBindEntity.userId"), @CacheEvict(key="'auth-bind'+#authBindEntity.id"), @CacheEvict(key="'person-name'+#authBindEntity.name")})
    public int updateByPk(PersonAuthBindEntity authBindEntity) {
        if (authBindEntity.getPositionIds() != null) {
            this.personPositionDao.deleteByPersonId((String)authBindEntity.getId());
            this.syncPositionInfo((String)authBindEntity.getId(), authBindEntity.getPositionIds());
        }
        if (authBindEntity.getPersonUser() != null) {
            this.syncUserInfo(authBindEntity);
        }
        return this.updateByPk((GenericEntity)authBindEntity);
    }

    @TransactionalEventListener
    @CacheEvict(allEntries=true)
    public void handleClearCache(ClearPersonCacheEvent event) {
        this.logger.debug("clear all person cache");
    }

    @Cacheable(key="'person-name'+#name")
    public List<PersonEntity> selectByName(String name) {
        if (StringUtils.isEmpty((Object)name)) {
            return new ArrayList<PersonEntity>();
        }
        return ((Query)this.createQuery().where("name", (Object)name)).listNoPaging();
    }

    @Cacheable(key="'auth-bind'+#id")
    public PersonAuthBindEntity selectAuthBindByPk(String id) {
        UserEntity userEntity;
        PersonEntity personEntity = (PersonEntity)this.selectByPk(id);
        if (personEntity == null) {
            return null;
        }
        if (personEntity instanceof PersonAuthBindEntity) {
            return (PersonAuthBindEntity)personEntity;
        }
        PersonAuthBindEntity bindEntity = (PersonAuthBindEntity)this.entityFactory.newInstance(PersonAuthBindEntity.class, (Object)personEntity);
        Set positionIds = ((Query)DefaultDSLQueryService.createQuery((QueryByEntityDao)this.personPositionDao).where("personId", (Object)id)).listNoPaging().stream().map(PositionAttachEntity::getPositionId).collect(Collectors.toSet());
        bindEntity.setPositionIds(positionIds);
        if (null != this.userService && null != personEntity.getUserId() && null != (userEntity = (UserEntity)this.userService.selectByPk((Object)personEntity.getUserId()))) {
            PersonUserEntity entity = (PersonUserEntity)this.entityFactory.newInstance(PersonUserEntity.class);
            entity.setUsername(userEntity.getUsername());
            bindEntity.setPersonUser(entity);
        }
        return bindEntity;
    }

    public List<PersonEntity> selectByPositionId(String positionId) {
        Objects.requireNonNull(positionId);
        return this.personDao.selectByPositionId(positionId);
    }

    public List<PersonEntity> selectByPositionIds(List<String> positionId) {
        return this.createQuery().where("id", "person-in-position", positionId).listNoPaging();
    }

    public List<PersonEntity> selectByDepartmentId(List<String> departmentId) {
        return this.createQuery().where("id", "person-in-department", departmentId).listNoPaging();
    }

    public List<PersonEntity> selectByOrgId(List<String> orgId) {
        return this.createQuery().where("id", "person-in-org", orgId).listNoPaging();
    }

    public PersonEntity selectByUserId(String userId) {
        return (PersonEntity)((Query)this.createQuery().where("userId", (Object)userId)).single();
    }

    public List<String> selectAllDepartmentId(List<String> personId) {
        if (CollectionUtils.isEmpty(personId)) {
            return new ArrayList<String>();
        }
        List positionId = ((Query)((Query)DefaultDSLQueryService.createQuery((QueryByEntityDao)this.personPositionDao).where()).in("personId", personId)).listNoPaging().stream().map(PositionAttachEntity::getPositionId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(positionId)) {
            return new ArrayList<String>();
        }
        return ((Query)((Query)DefaultDSLQueryService.createQuery((QueryByEntityDao)this.positionDao).where()).in("id", positionId)).listNoPaging().stream().map(DepartmentAttachEntity::getDepartmentId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public List<String> selectAllOrgId(List<String> personId) {
        List<String> departmentId = this.selectAllDepartmentId(personId);
        if (CollectionUtils.isEmpty(departmentId)) {
            return new ArrayList<String>();
        }
        return ((Query)((Query)DefaultDSLQueryService.createQuery((QueryByEntityDao)this.departmentDao).where()).in("id", departmentId)).listNoPaging().stream().map(OrgAttachEntity::getOrgId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public List<PersonEntity> selectByRoleId(String roleId) {
        Objects.requireNonNull(roleId);
        return this.personDao.selectByRoleId(roleId);
    }

    protected void syncPositionInfo(String personId, Set<String> positionIds) {
        for (String positionId : positionIds) {
            PersonPositionEntity positionEntity = (PersonPositionEntity)this.entityFactory.newInstance(PersonPositionEntity.class);
            positionEntity.setPersonId(personId);
            positionEntity.setPositionId(positionId);
            this.personPositionDao.insert(positionEntity);
        }
    }

    protected void syncUserInfo(PersonAuthBindEntity bindEntity) {
        if (StringUtils.isEmpty((Object)bindEntity.getPersonUser().getUsername())) {
            bindEntity.setUserId("");
            return;
        }
        if (null == this.userService) {
            this.logger.warn("userService not ready!");
            return;
        }
        UserEntity oldUser = this.userService.selectByUsername(bindEntity.getPersonUser().getUsername());
        if (null != oldUser) {
            int userBindSize = ((Query)((Query)((Query)this.createQuery().where()).is("userId", oldUser.getId())).not("id", bindEntity.getId())).total();
            this.tryValidateProperty(userBindSize == 0, "personUser.username", "\u7528\u6237\u5df2\u7ed1\u5b9a\u5176\u4ed6\u4eba\u5458");
        }
        Function<UserEntity, String> userOperationFunction = oldUser == null ? arg_0 -> ((UserService)this.userService).insert(arg_0) : user -> {
            this.userService.update((String)oldUser.getId(), user);
            return (String)oldUser.getId();
        };
        UserEntity userEntity = (UserEntity)this.entityFactory.newInstance(UserEntity.class);
        userEntity.setUsername(bindEntity.getPersonUser().getUsername());
        userEntity.setPassword(bindEntity.getPersonUser().getPassword());
        userEntity.setName(bindEntity.getName());
        String userId = userOperationFunction.apply(userEntity);
        bindEntity.setUserId(userId);
    }

    @CacheEvict(allEntries=true)
    public PersonEntity deleteByPk(String id) {
        this.personPositionDao.deleteByPersonId(id);
        return (PersonEntity)super.deleteByPk((Object)id);
    }

    @Cacheable(key="'auth:persion-id'+#personId")
    public PersonnelAuthentication getPersonnelAuthorizationByPersonId(String personId) {
        PersonEntity entity = (PersonEntity)this.selectByPk(personId);
        if (null == entity) {
            return null;
        }
        SimplePersonnelAuthentication authorization = new SimplePersonnelAuthentication();
        Personnel personnel = (Personnel)this.entityFactory.newInstance(Personnel.class, SimplePersonnel.class, (Object)entity);
        authorization.setPersonnel(personnel);
        Set<String> positionIds = ((Query)DefaultDSLQueryService.createQuery((QueryByEntityDao)this.personPositionDao).where("personId", (Object)personId)).listNoPaging().stream().map(PositionAttachEntity::getPositionId).collect(Collectors.toSet());
        HashMap departmentCache = new HashMap();
        HashMap positionCache = new HashMap();
        HashMap orgCache = new HashMap();
        HashMap districtCache = new HashMap();
        List<PositionEntity> positionEntities = this.getAllChildrenAndReturnRootNode((QueryByEntityDao)this.positionDao, positionIds, (BiConsumer)PositionEntity::setChildren, rootPosList -> {
            Set<String> departmentIds = rootPosList.stream().peek(positionEntity -> positionCache.put(positionEntity.getId(), positionEntity)).map(DepartmentAttachEntity::getDepartmentId).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(departmentIds)) {
                List<DepartmentEntity> departmentEntities = this.getAllChildrenAndReturnRootNode((QueryByEntityDao)this.departmentDao, departmentIds, (BiConsumer)DepartmentEntity::setChildren, rootDepList -> {
                    Set<String> orgIds = rootDepList.stream().peek(departmentEntity -> departmentCache.put(departmentEntity.getId(), departmentEntity)).map(OrgAttachEntity::getOrgId).collect(Collectors.toSet());
                    if (!CollectionUtils.isEmpty(orgIds)) {
                        List<OrganizationalEntity> orgEntities = this.getAllChildrenAndReturnRootNode((QueryByEntityDao)this.organizationalDao, orgIds, (BiConsumer)OrganizationalEntity::setChildren, rootOrgList -> {
                            Set<String> districtIds = rootOrgList.stream().peek(org -> orgCache.put(org.getId(), org)).map(DistrictAttachEntity::getDistrictId).filter(Objects::nonNull).collect(Collectors.toSet());
                            if (!CollectionUtils.isEmpty(districtIds)) {
                                List<DistrictEntity> districtEntities = this.getAllChildrenAndReturnRootNode((QueryByEntityDao)this.districtDao, districtIds, (BiConsumer)DistrictEntity::setChildren, rootDistrictList -> rootDistrictList.forEach(dist -> districtCache.put(dist.getId(), dist)));
                                authorization.setDistrictIds(SimplePersonService.transformationTreeNode(null, districtEntities));
                            }
                        });
                        authorization.setOrgIds(SimplePersonService.transformationTreeNode(null, orgEntities));
                    }
                });
                authorization.setDepartmentIds(SimplePersonService.transformationTreeNode(null, departmentEntities));
            }
        });
        authorization.setPositionIds(SimplePersonService.transformationTreeNode(null, positionEntities));
        Set positions = positionEntities.stream().map(positionEntity -> {
            DepartmentEntity departmentEntity = (DepartmentEntity)departmentCache.get(positionEntity.getDepartmentId());
            if (departmentEntity == null) {
                return null;
            }
            OrganizationalEntity organizationalEntity = (OrganizationalEntity)orgCache.get(departmentEntity.getOrgId());
            if (organizationalEntity == null) {
                return null;
            }
            DistrictEntity districtEntity = (DistrictEntity)districtCache.get(organizationalEntity.getDistrictId());
            SimpleDistrict district = districtEntity == null ? null : SimpleDistrict.builder().code(districtEntity.getCode()).id((String)districtEntity.getId()).name(districtEntity.getName()).fullName(districtEntity.getFullName()).build();
            SimpleOrganization organization = SimpleOrganization.builder().id((String)organizationalEntity.getId()).name(organizationalEntity.getName()).fullName(organizationalEntity.getFullName()).code(organizationalEntity.getCode()).district((District)district).build();
            SimpleDepartment department = SimpleDepartment.builder().id((String)departmentEntity.getId()).name(departmentEntity.getName()).code(departmentEntity.getCode()).org((Organization)organization).build();
            return SimplePosition.builder().id((String)positionEntity.getId()).name(positionEntity.getName()).department((Department)department).code("").build();
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        authorization.setPositions(positions);
        List relationInfoList = ((Query)((Query)DefaultDSLQueryService.createQuery((QueryByEntityDao)this.relationInfoDao).where("relationFrom", (Object)personId)).or("relationTo", (Object)personId)).listNoPaging();
        List relations = relationInfoList.stream().map(info -> {
            SimpleRelation relation = new SimpleRelation();
            relation.setDimension(info.getRelationTypeFrom());
            relation.setTarget(info.getRelationTo());
            relation.setRelation(info.getRelationId());
            if (personId.equals(info.getRelationFrom())) {
                relation.setDirection(Relation.Direction.POSITIVE);
            } else {
                relation.setDirection(Relation.Direction.REVERSE);
            }
            return relation;
        }).collect(Collectors.toList());
        authorization.setRelations((Relations)new SimpleRelations(relations));
        return authorization;
    }

    protected <T extends TreeSupportEntity<String>> List<T> getAllChildrenAndReturnRootNode(QueryByEntityDao<T> dao, Set<String> rootIds, BiConsumer<T, List<T>> childAccepter, Consumer<List<T>> rootConsumer) {
        if (CollectionUtils.isEmpty(rootIds)) {
            return new ArrayList();
        }
        List root = ((Query)((Query)DefaultDSLQueryService.createQuery(dao).where()).in("id", rootIds)).listNoPaging();
        if (!root.isEmpty()) {
            List allNode = ((Query)DefaultDSLQueryService.createQuery(dao).each((Collection)root, (query, data) -> {
                Query cfr_ignored_0 = (Query)query.or().like$("path", (Object)data.getPath());
            })).listNoPaging();
            List tree = TreeSupportEntity.list2tree((Collection)allNode, childAccepter, node -> rootIds.contains(node.getId()));
            rootConsumer.accept(root);
            return tree;
        }
        return new ArrayList();
    }

    public static <V extends TreeSupportEntity<String>> Set<TreeNode<String>> transformationTreeNode(V parent, List<V> data) {
        HashSet<TreeNode<String>> treeNodes = new HashSet<TreeNode<String>>();
        data.forEach(node -> {
            TreeNode treeNode = new TreeNode();
            if (parent != null) {
                TreeNode parentNode = new TreeNode();
                parentNode.setValue(parent.getId());
                parentNode.setChildren(treeNodes);
            }
            treeNode.setValue(node.getId());
            if (node.getChildren() != null && !node.getChildren().isEmpty()) {
                treeNode.setChildren(SimplePersonService.transformationTreeNode(node, node.getChildren()));
            }
            treeNodes.add(treeNode);
        });
        return treeNodes;
    }

    @Cacheable(key="'auth:user-id'+#userId")
    public PersonnelAuthentication getPersonnelAuthorizationByUserId(String userId) {
        PersonEntity entity = (PersonEntity)((Query)this.createQuery().where("userId", (Object)userId)).single();
        if (entity == null) {
            return null;
        }
        return this.getPersonnelAuthorizationByPersonId((String)entity.getId());
    }
}

