/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.oauth2.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.oauth2.server.client.OAuth2Client;
import org.hswebframework.web.authorization.oauth2.server.client.OAuth2ClientConfigRepository;
import org.hswebframework.web.controller.message.ResponseMessage;
import org.hswebframework.web.entity.oauth2.server.OAuth2ClientEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/oauth2-client-config"})
@Api(tags={"OAuth2.0-\u670d\u52a1-\u5ba2\u6237\u7aef\u7ba1\u7406"}, value="OAuth2.0-\u670d\u52a1-\u5ba2\u6237\u7aef\u7ba1\u7406")
@Authorize(permission={"oauth2-client-config"}, description={"OAuth2.0-\u670d\u52a1-\u5ba2\u6237\u7aef\u7ba1\u7406"})
public class OAuth2ClientConfigController {
    @Autowired
    private OAuth2ClientConfigRepository repository;

    @GetMapping
    @Authorize(action={"query"})
    @ApiOperation(value="\u83b7\u53d6\u5168\u90e8\u5ba2\u6237\u7aef")
    public ResponseMessage<List<OAuth2Client>> getAllClient() {
        return ResponseMessage.ok((Object)this.repository.getAll());
    }

    @GetMapping(value={"/{id}"})
    @Authorize(action={"get"})
    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u5ba2\u6237\u7aef")
    public ResponseMessage<OAuth2Client> getById(@PathVariable String id) {
        return ResponseMessage.ok((Object)this.repository.getClientById(id));
    }

    @GetMapping(value={"/owner/{userId}"})
    @Authorize(action={"get"})
    @ApiOperation(value="\u6839\u636e\u7ed1\u5b9a\u5230\u7528\u6237\u5230\u5ba2\u6237\u7aef")
    public ResponseMessage<OAuth2Client> getByOwnerId(@PathVariable String userId) {
        return ResponseMessage.ok((Object)this.repository.getClientByOwnerId(userId));
    }

    @PatchMapping
    @Authorize(action={"update"})
    @ApiOperation(value="\u4fdd\u5b58\u5ba2\u6237\u7aef", notes="\u5982\u679c\u5ba2\u6237\u7aef\u4e0d\u5b58\u5728\u5219\u81ea\u52a8\u65b0\u589e")
    public ResponseMessage<OAuth2Client> saveOrUpdate(@RequestBody OAuth2ClientEntity clientEntity) {
        Authentication authentication = Authentication.current().orElse(null);
        if (null != authentication) {
            clientEntity.setCreatorId(authentication.getUser().getId());
        }
        clientEntity.setCreateTimeNow();
        return ResponseMessage.ok((Object)this.repository.save((OAuth2Client)clientEntity));
    }

    @DeleteMapping(value={"/{id}"})
    @Authorize(action={"delete"})
    @ApiOperation(value="\u5220\u9664\u5ba2\u6237\u7aef")
    public ResponseMessage<OAuth2Client> removeById(@PathVariable String id) {
        return ResponseMessage.ok((Object)this.repository.remove(id));
    }
}

