/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.oauth2.authorization;

import javax.servlet.http.HttpServletRequest;
import org.hswebframework.web.authorization.basic.web.AuthorizedToken;
import org.hswebframework.web.authorization.basic.web.ParsedToken;
import org.hswebframework.web.authorization.basic.web.UserTokenParser;
import org.hswebframework.web.authorization.oauth2.server.OAuth2AccessToken;
import org.hswebframework.web.authorization.oauth2.server.exception.GrantTokenException;
import org.hswebframework.web.authorization.oauth2.server.token.AccessTokenService;
import org.hswebframework.web.oauth2.core.ErrorType;
import org.springframework.util.StringUtils;

public class OAuth2UserTokenParser
implements UserTokenParser {
    public static final String token_type = "oauth2-access-token";
    private AccessTokenService accessTokenService;

    public OAuth2UserTokenParser(AccessTokenService accessTokenService) {
        this.accessTokenService = accessTokenService;
    }

    public void setAccessTokenService(AccessTokenService accessTokenService) {
        this.accessTokenService = accessTokenService;
    }

    public ParsedToken parseToken(HttpServletRequest request) {
        Long time;
        if (request.getRequestURI().contains("oauth2") && request.getParameter("grant_type") != null) {
            return null;
        }
        String accessToken = request.getHeader("Authorization");
        if (StringUtils.isEmpty((Object)accessToken)) {
            accessToken = request.getParameter("access_token");
        } else {
            String[] arr = accessToken.split("[ ]");
            if (arr.length > 1 && ("Bearer".equalsIgnoreCase(arr[0]) || "OAuth".equalsIgnoreCase(arr[0]))) {
                accessToken = arr[1];
            }
        }
        if (StringUtils.isEmpty((Object)accessToken)) {
            return null;
        }
        final OAuth2AccessToken auth2AccessToken = this.accessTokenService.getTokenByAccessToken(accessToken);
        if (auth2AccessToken == null) {
            throw new GrantTokenException(ErrorType.INVALID_TOKEN);
        }
        Long l = time = auth2AccessToken.getUpdateTime() != null ? auth2AccessToken.getUpdateTime() : auth2AccessToken.getCreateTime();
        if (System.currentTimeMillis() - time > (long)auth2AccessToken.getExpiresIn().intValue() * 1000L) {
            throw new GrantTokenException(ErrorType.EXPIRED_TOKEN);
        }
        return new AuthorizedToken(){

            public String getUserId() {
                return auth2AccessToken.getOwnerId();
            }

            public String getToken() {
                return auth2AccessToken.getAccessToken();
            }

            public String getType() {
                return OAuth2UserTokenParser.token_type;
            }

            public long getMaxInactiveInterval() {
                return (long)auth2AccessToken.getExpiresIn().intValue() * 1000L;
            }
        };
    }
}

