/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.oauth2;

import org.hswebframework.web.authorization.AuthenticationManager;
import org.hswebframework.web.authorization.oauth2.server.client.OAuth2ClientConfigRepository;
import org.hswebframework.web.authorization.oauth2.server.support.AbstractAuthorizationService;
import org.hswebframework.web.authorization.oauth2.server.support.DefaultOAuth2Granter;
import org.hswebframework.web.authorization.oauth2.server.support.client.ClientCredentialGranter;
import org.hswebframework.web.authorization.oauth2.server.support.client.DefaultClientCredentialGranter;
import org.hswebframework.web.authorization.oauth2.server.support.code.AuthorizationCodeGranter;
import org.hswebframework.web.authorization.oauth2.server.support.code.AuthorizationCodeService;
import org.hswebframework.web.authorization.oauth2.server.support.code.DefaultAuthorizationCodeGranter;
import org.hswebframework.web.authorization.oauth2.server.support.implicit.DefaultImplicitGranter;
import org.hswebframework.web.authorization.oauth2.server.support.implicit.ImplicitGranter;
import org.hswebframework.web.authorization.oauth2.server.support.password.DefaultPasswordGranter;
import org.hswebframework.web.authorization.oauth2.server.support.password.PasswordGranter;
import org.hswebframework.web.authorization.oauth2.server.support.password.PasswordService;
import org.hswebframework.web.authorization.oauth2.server.support.refresh.DefaultRefreshTokenGranter;
import org.hswebframework.web.authorization.oauth2.server.support.refresh.RefreshTokenGranter;
import org.hswebframework.web.authorization.oauth2.server.token.AccessTokenService;
import org.hswebframework.web.authorization.token.UserTokenManager;
import org.hswebframework.web.commons.entity.factory.EntityFactory;
import org.hswebframework.web.dao.oauth2.server.AuthorizationCodeDao;
import org.hswebframework.web.dao.oauth2.server.OAuth2AccessDao;
import org.hswebframework.web.dao.oauth2.server.OAuth2ClientDao;
import org.hswebframework.web.oauth2.OAuth2GrantEventListener;
import org.hswebframework.web.service.oauth2.server.simple.CodeGenerator;
import org.hswebframework.web.service.oauth2.server.simple.SimpleAccessTokenService;
import org.hswebframework.web.service.oauth2.server.simple.SimpleAuthorizationCodeService;
import org.hswebframework.web.service.oauth2.server.simple.SimpleClientConfigRepository;
import org.hswebframework.web.service.oauth2.server.simple.SimplePasswordService;
import org.hswebframework.web.service.oauth2.server.simple.TokenGenerator;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(value={"org.hswebframework.web.service.oauth2.server.simple", "org.hswebframework.web.authorization.oauth2.controller"})
public class OAuth2GranterAutoConfiguration {
    @Autowired(required=false)
    private CodeGenerator codeGenerator;
    @Autowired(required=false)
    private TokenGenerator tokenGenerator;

    @ConditionalOnMissingBean(value={AuthorizationCodeService.class})
    @Bean
    public SimpleAuthorizationCodeService simpleAuthorizationCodeService(AuthorizationCodeDao authorizationCodeDao, EntityFactory entityFactory) {
        return new SimpleAuthorizationCodeService(authorizationCodeDao, entityFactory).setCodeGenerator(this.codeGenerator);
    }

    @ConditionalOnMissingBean(value={OAuth2ClientConfigRepository.class})
    @Bean
    public SimpleClientConfigRepository simpleClientService(OAuth2ClientDao oAuth2ClientDao) {
        return new SimpleClientConfigRepository(oAuth2ClientDao);
    }

    @ConditionalOnMissingBean(value={PasswordService.class})
    @Bean
    public SimplePasswordService simplePasswordService(AuthenticationManager userService) {
        return new SimplePasswordService(userService);
    }

    @ConditionalOnMissingBean(value={AccessTokenService.class})
    @Bean
    public SimpleAccessTokenService simpleAccessTokenService(OAuth2AccessDao oAuth2AccessDao, EntityFactory entityFactory) {
        return new SimpleAccessTokenService(oAuth2AccessDao, entityFactory).setTokenGenerator(this.tokenGenerator);
    }

    @Bean
    @ConditionalOnBean(value={UserTokenManager.class})
    public OAuth2GrantEventListener oAuth2GrantEventListener(UserTokenManager userTokenManager) {
        return new OAuth2GrantEventListener(userTokenManager);
    }

    @Bean
    public AutoSettingOAuth2Granter autoSettingOAuth2Granter() {
        return new AutoSettingOAuth2Granter();
    }

    class AutoSettingOAuth2Granter
    extends DefaultOAuth2Granter
    implements BeanPostProcessor {
        AutoSettingOAuth2Granter() {
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof AuthorizationCodeGranter) {
                this.addAuthorizationCodeSupport((AuthorizationCodeGranter)bean);
            }
            if (bean instanceof ClientCredentialGranter) {
                this.addClientCredentialSupport((ClientCredentialGranter)bean);
            }
            if (bean instanceof PasswordGranter) {
                this.addPasswordSupport((PasswordGranter)bean);
            }
            if (bean instanceof ImplicitGranter) {
                this.addImplicitSupport((ImplicitGranter)bean);
            }
            if (bean instanceof RefreshTokenGranter) {
                this.addRefreshTokenSupport((RefreshTokenGranter)bean);
            }
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }
    }

    @Configuration
    public static class OAuth2GranterConfiguration {
        @Autowired
        private AuthorizationCodeService authorizationCodeService;
        @Autowired
        private OAuth2ClientConfigRepository oAuth2ClientConfigRepository;
        @Autowired
        private AccessTokenService accessTokenService;
        @Autowired
        private PasswordService passwordService;

        private <T extends AbstractAuthorizationService> T setProperty(T abstractAuthorizationService) {
            abstractAuthorizationService.setAccessTokenService(this.accessTokenService);
            abstractAuthorizationService.setRepository(this.oAuth2ClientConfigRepository);
            return abstractAuthorizationService;
        }

        @Bean
        @ConditionalOnMissingBean(value={AuthorizationCodeGranter.class})
        public AuthorizationCodeGranter authorizationCodeGranter() {
            return (AuthorizationCodeGranter)this.setProperty(new DefaultAuthorizationCodeGranter(this.authorizationCodeService));
        }

        @Bean
        @ConditionalOnMissingBean(value={ClientCredentialGranter.class})
        public ClientCredentialGranter clientCredentialGranter() {
            return (ClientCredentialGranter)this.setProperty(new DefaultClientCredentialGranter());
        }

        @Bean
        @ConditionalOnMissingBean(value={PasswordGranter.class})
        public PasswordGranter passwordGranter() {
            return (PasswordGranter)this.setProperty(new DefaultPasswordGranter(this.passwordService));
        }

        @Bean
        @ConditionalOnMissingBean(value={ImplicitGranter.class})
        public ImplicitGranter implicitGranter() {
            return (ImplicitGranter)this.setProperty(new DefaultImplicitGranter());
        }

        @Bean
        @ConditionalOnMissingBean(value={RefreshTokenGranter.class})
        @ConfigurationProperties(prefix="hsweb.oauth2.server")
        public RefreshTokenGranter refreshTokenGranter() {
            return (RefreshTokenGranter)this.setProperty(new DefaultRefreshTokenGranter());
        }
    }
}

