/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.oauth2.server.simple;

import java.util.List;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.ezorm.core.dsl.Update;
import org.hswebframework.web.authorization.oauth2.server.client.OAuth2Client;
import org.hswebframework.web.authorization.oauth2.server.client.OAuth2ClientConfigRepository;
import org.hswebframework.web.commons.entity.DataStatus;
import org.hswebframework.web.commons.entity.Entity;
import org.hswebframework.web.commons.entity.param.QueryParamEntity;
import org.hswebframework.web.dao.dynamic.QueryByEntityDao;
import org.hswebframework.web.dao.dynamic.UpdateByEntityDao;
import org.hswebframework.web.dao.oauth2.server.OAuth2ClientDao;
import org.hswebframework.web.entity.oauth2.server.SimpleOAuth2ClientEntity;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.service.DefaultDSLQueryService;
import org.hswebframework.web.service.DefaultDSLUpdateService;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;

@CacheConfig(cacheNames={"oauth2-client-config"})
public class SimpleClientConfigRepository
implements OAuth2ClientConfigRepository {
    private OAuth2ClientDao oAuth2ClientDao;

    public SimpleClientConfigRepository(OAuth2ClientDao oAuth2ClientDao) {
        this.oAuth2ClientDao = oAuth2ClientDao;
    }

    @Cacheable(key="'id:'+#id")
    public OAuth2Client getClientById(String id) {
        return (OAuth2Client)((Query)DefaultDSLQueryService.createQuery((QueryByEntityDao)this.oAuth2ClientDao).where("id", (Object)id)).single();
    }

    @Cacheable(key="'ownerId:'+#ownerId")
    public OAuth2Client getClientByOwnerId(String ownerId) {
        return (OAuth2Client)((Query)DefaultDSLQueryService.createQuery((QueryByEntityDao)this.oAuth2ClientDao).where("ownerId", (Object)ownerId)).single();
    }

    @Caching(put={@CachePut(key="'ownerId:'+#result.ownerId"), @CachePut(key="'id:'+#result.id")})
    public OAuth2Client save(OAuth2Client oAuth2Client) {
        OAuth2Client old = this.getClientById(oAuth2Client.getId());
        if (old != null) {
            ((Update)DefaultDSLUpdateService.createUpdate((UpdateByEntityDao)this.oAuth2ClientDao, (Object)oAuth2Client).excludes(new String[]{"id", "createTime"}).where("id", (Object)oAuth2Client.getId())).exec();
        } else {
            this.oAuth2ClientDao.insert((SimpleOAuth2ClientEntity)oAuth2Client);
        }
        return oAuth2Client;
    }

    @Caching(evict={@CacheEvict(key="'ownerId:'+#result.ownerId", condition="#result!=null"), @CacheEvict(key="'id:'+#result.id", condition="#result!=null")})
    public OAuth2Client remove(String id) {
        OAuth2Client old = this.getClientById(id);
        this.oAuth2ClientDao.deleteByPk(id);
        return old;
    }

    public OAuth2Client newClient() {
        SimpleOAuth2ClientEntity clientEntity = SimpleOAuth2ClientEntity.builder().build();
        clientEntity.setId(IDGenerator.MD5.generate());
        clientEntity.setSecret((String)IDGenerator.MD5.generate());
        clientEntity.setStatus(DataStatus.STATUS_ENABLED);
        clientEntity.setCreateTimeNow();
        return clientEntity;
    }

    public List<OAuth2Client> getAll() {
        QueryParamEntity entity = new QueryParamEntity();
        entity.setPaging(false);
        return this.oAuth2ClientDao.query((Entity)entity);
    }
}

