/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.oauth2.server.simple;

import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.ezorm.core.dsl.Update;
import org.hswebframework.web.authorization.oauth2.server.OAuth2AccessToken;
import org.hswebframework.web.authorization.oauth2.server.token.AccessTokenService;
import org.hswebframework.web.commons.entity.factory.EntityFactory;
import org.hswebframework.web.dao.dynamic.QueryByEntityDao;
import org.hswebframework.web.dao.dynamic.UpdateByEntityDao;
import org.hswebframework.web.dao.oauth2.server.OAuth2AccessDao;
import org.hswebframework.web.entity.oauth2.server.OAuth2AccessEntity;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.service.DefaultDSLQueryService;
import org.hswebframework.web.service.DefaultDSLUpdateService;
import org.hswebframework.web.service.oauth2.server.simple.TokenGenerator;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class SimpleAccessTokenService
implements AccessTokenService {
    private TokenGenerator tokenGenerator = () -> ((IDGenerator)IDGenerator.MD5).generate();
    private OAuth2AccessDao oAuth2AccessDao;
    private EntityFactory entityFactory;

    public SimpleAccessTokenService(OAuth2AccessDao oAuth2AccessDao, EntityFactory entityFactory) {
        this.oAuth2AccessDao = oAuth2AccessDao;
        this.entityFactory = entityFactory;
    }

    public SimpleAccessTokenService setTokenGenerator(TokenGenerator tokenGenerator) {
        if (tokenGenerator != null) {
            this.tokenGenerator = tokenGenerator;
        }
        return this;
    }

    @Cacheable(cacheNames={"oauth2-access-token"}, key="'cgo'+#token.clientId+#token.grantType+#token.ownerId")
    public OAuth2AccessToken tryGetOldToken(OAuth2AccessToken token) {
        OAuth2AccessToken old = (OAuth2AccessToken)((Query)((Query)((Query)DefaultDSLQueryService.createQuery((QueryByEntityDao)this.oAuth2AccessDao).where("clientId", (Object)token.getClientId())).and("grantType", (Object)token.getGrantType())).and("ownerId", (Object)token.getOwnerId())).single();
        return old;
    }

    public OAuth2AccessToken createToken() {
        OAuth2AccessEntity accessEntity = (OAuth2AccessEntity)this.entityFactory.newInstance(OAuth2AccessEntity.class);
        accessEntity.setAccessToken(this.tokenGenerator.generate());
        accessEntity.setRefreshToken(this.tokenGenerator.generate());
        accessEntity.setCreateTime(System.currentTimeMillis());
        return accessEntity;
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    @Cacheable(cacheNames={"oauth2-access-token"}, key="'refresh:'+#refreshToken")
    public OAuth2AccessToken getTokenByRefreshToken(String refreshToken) {
        Assert.notNull((Object)refreshToken, (String)"refreshToken can not be null!");
        return (OAuth2AccessToken)((Query)DefaultDSLQueryService.createQuery((QueryByEntityDao)this.oAuth2AccessDao).where("refreshToken", (Object)refreshToken)).single();
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    @Cacheable(cacheNames={"oauth2-access-token"}, key="'token:'+#accessToken")
    public OAuth2AccessToken getTokenByAccessToken(String accessToken) {
        Assert.notNull((Object)accessToken, (String)"accessToken can not be null!");
        return (OAuth2AccessToken)((Query)DefaultDSLQueryService.createQuery((QueryByEntityDao)this.oAuth2AccessDao).where("accessToken", (Object)accessToken)).single();
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    @Caching(put={@CachePut(cacheNames={"oauth2-access-token"}, key="'refresh:'+#result.refreshToken"), @CachePut(cacheNames={"oauth2-access-token"}, key="'token:'+#result.accessToken"), @CachePut(cacheNames={"oauth2-access-token"}, key="'cgo'+#result.clientId+#result.grantType+#result.ownerId")})
    public OAuth2AccessToken saveOrUpdateToken(OAuth2AccessToken token) {
        Assert.notNull((Object)token, (String)"token can not be null!");
        int total = ((Query)((Query)((Query)DefaultDSLQueryService.createQuery((QueryByEntityDao)this.oAuth2AccessDao).where("clientId", (Object)token.getClientId())).and("grantType", (Object)token.getGrantType())).and("ownerId", (Object)token.getOwnerId())).total();
        token.setUpdateTime(Long.valueOf(System.currentTimeMillis()));
        if (total > 0) {
            ((Update)((Update)((Update)DefaultDSLUpdateService.createUpdate((UpdateByEntityDao)this.oAuth2AccessDao, (Object)token).where("clientId", (Object)token.getClientId())).and("grantType", (Object)token.getGrantType())).and("ownerId", (Object)token.getOwnerId())).exec();
        } else {
            token.setCreateTime(Long.valueOf(System.currentTimeMillis()));
            this.oAuth2AccessDao.insert((OAuth2AccessEntity)token);
        }
        return token;
    }
}

