/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.oauth2.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.hswebframework.web.WebUtil;
import org.hswebframework.web.authorization.oauth2.client.OAuth2RequestService;
import org.hswebframework.web.authorization.oauth2.client.listener.OAuth2CodeAuthBeforeEvent;
import org.hswebframework.web.authorization.oauth2.client.listener.OAuth2Event;
import org.hswebframework.web.controller.message.ResponseMessage;
import org.hswebframework.web.entity.oauth2.client.OAuth2ServerConfigEntity;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.service.oauth2.client.OAuth2ServerConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@RequestMapping(value={"${hsweb.web.mappings.oauth2-client-callback:oauth2}"})
@Api(tags={"OAuth2.0-\u5ba2\u6237\u7aef-\u8bf7\u6c42\u670d\u52a1"}, value="OAuth2.0\u5ba2\u6237\u7aef\u8bf7\u6c42\u670d\u52a1")
public class OAuth2ClientController {
    private OAuth2RequestService oAuth2RequestService;
    private OAuth2ServerConfigService oAuth2ServerConfigService;
    private static final String STATE_SESSION_KEY = "OAUTH2_STATE";

    @Autowired
    public void setoAuth2ServerConfigService(OAuth2ServerConfigService oAuth2ServerConfigService) {
        this.oAuth2ServerConfigService = oAuth2ServerConfigService;
    }

    @Autowired
    public void setoAuth2RequestService(OAuth2RequestService oAuth2RequestService) {
        this.oAuth2RequestService = oAuth2RequestService;
    }

    @GetMapping(value={"/state"})
    @ResponseBody
    @ApiOperation(value="\u7533\u8bf7\u4e00\u4e2astate")
    public ResponseMessage<String> requestState(HttpSession session) {
        String state = (String)IDGenerator.RANDOM.generate();
        session.setAttribute(STATE_SESSION_KEY, (Object)state);
        return ResponseMessage.ok((Object)state);
    }

    @GetMapping(value={"/boot/{serverId}"})
    @ApiOperation(value="\u8df3\u8f6c\u81f3OAuth2.0\u670d\u52a1\u6388\u6743\u9875\u9762")
    public RedirectView boot(@PathVariable String serverId, @RequestParam(defaultValue="/") String redirect, HttpServletRequest request, HttpSession session) throws UnsupportedEncodingException {
        OAuth2ServerConfigEntity entity = (OAuth2ServerConfigEntity)this.oAuth2ServerConfigService.selectByPk((Object)serverId);
        if (entity == null) {
            return new RedirectView("/401.html");
        }
        String callback = WebUtil.getBasePath((HttpServletRequest)request).concat("oauth2/callback/").concat(serverId).concat("/?redirect=").concat(URLEncoder.encode(redirect, "UTF-8"));
        RedirectView view = new RedirectView(entity.getRealUrl(entity.getAuthUrl()));
        view.addStaticAttribute("response_type", (Object)"code");
        view.addStaticAttribute("state", this.requestState(session).getResult());
        view.addStaticAttribute("client_id", (Object)entity.getClientId());
        view.addStaticAttribute("redirect_uri", (Object)callback);
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/callback/{serverId}"})
    @ApiOperation(value="OAuth2.0\u6388\u6743\u5b8c\u6210\u540e\u56de\u8c03", hidden=true)
    public RedirectView callback(@RequestParam(defaultValue="/") String redirect, @PathVariable String serverId, @RequestParam String code, @RequestParam String state, HttpServletRequest request, HttpSession session) throws UnsupportedEncodingException {
        try {
            String cachedState = (String)session.getAttribute(STATE_SESSION_KEY);
            this.oAuth2RequestService.doEvent(serverId, (OAuth2Event)new OAuth2CodeAuthBeforeEvent(code, state, arg_0 -> ((HttpServletRequest)request).getParameter(arg_0)));
            RedirectView redirectView = new RedirectView(URLDecoder.decode(redirect, "UTF-8"));
            return redirectView;
        }
        finally {
            session.removeAttribute(STATE_SESSION_KEY);
        }
    }
}

