/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.controller.file;

import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.fileupload.ParameterParser;
import org.hswebframework.expands.compress.Compress;
import org.hswebframework.expands.compress.zip.ZIPWriter;
import org.hswebframework.utils.StringUtils;
import org.hswebframework.web.BusinessException;
import org.hswebframework.web.NotFoundException;
import org.hswebframework.web.WebUtil;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.commons.entity.DataStatus;
import org.hswebframework.web.controller.message.ResponseMessage;
import org.hswebframework.web.entity.file.FileInfoEntity;
import org.hswebframework.web.service.file.FileInfoService;
import org.hswebframework.web.service.file.FileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"${hsweb.web.mappings.file:file}"})
@Authorize(permission={"file"}, description={"\u6587\u4ef6\u7ba1\u7406"})
@Api(value="\u6587\u4ef6\u7ba1\u7406", tags={"\u6587\u4ef6\u7ba1\u7406-\u6587\u4ef6\u64cd\u4f5c"})
public class FileController {
    private FileService fileService;
    private FileInfoService fileInfoService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Pattern fileNameKeyWordPattern = Pattern.compile("(\\\\)|(/)|(:)(|)|(\\?)|(>)|(<)|(\")");

    @Autowired
    public void setFileService(FileService fileService) {
        this.fileService = fileService;
    }

    @Autowired
    public void setFileInfoService(FileInfoService fileInfoService) {
        this.fileInfoService = fileInfoService;
    }

    @RequestMapping(value={"/download-zip/{name:.+}"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6784\u5efazip\u6587\u4ef6\u5e76\u4e0b\u8f7d")
    @Authorize(action={"download"}, description={"\u4e0b\u8f7d\u6587\u4ef6"})
    public void downloadZip(@ApiParam(value="zip\u6587\u4ef6\u540d") @PathVariable(value="name") String name, @ApiParam(value="zip\u6587\u4ef6\u5185\u5bb9", example="[{\"name\":\"textFile.txt\",\"text\":\"fileText\"},{\"name\":\"uploadedFile.png\",\"file\":\"fileId or file md5\"}{\"name\":\"base64File.text\",\"base64\":\"aGVsbG8=\"}]") @RequestParam(value="data") String dataStr, HttpServletResponse response) throws IOException {
        response.setContentType("application/octet-stream");
        response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode(name, "utf-8"));
        ZIPWriter writer = Compress.zip();
        List data = JSON.parseArray((String)dataStr, Map.class);
        data.forEach(map -> {
            String entryName = (String)map.get("name");
            String text = (String)map.get("text");
            String file = (String)map.get("file");
            String fileBase64 = (String)map.get("base64");
            if (text != null) {
                writer.addTextFile((String)map.get("name"), text);
            } else if (file != null) {
                writer.addFile(entryName, this.fileService.readFile(file));
            } else if (fileBase64 != null) {
                writer.addFile(entryName, (InputStream)new ByteArrayInputStream(Base64.decodeBase64((String)fileBase64)));
            }
        });
        writer.write((OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/download-text/{name:.+}"}, method={RequestMethod.GET, RequestMethod.POST})
    @ApiOperation(value="\u6784\u5efa\u6587\u672c\u6587\u4ef6\u5e76\u4e0b\u8f7d")
    @Authorize(action={"download"}, description={"\u4e0b\u8f7d\u6587\u4ef6"})
    public void downloadTxt(@ApiParam(value="\u6587\u4ef6\u540d") @PathVariable(value="name") String name, @ApiParam(value="\u6587\u672c\u5185\u5bb9") @RequestParam(value="text") String text, HttpServletResponse response) throws IOException {
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/octet-stream; charset=utf-8");
        response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode(name, "utf-8"));
        response.getWriter().write(text);
    }

    @RequestMapping(value={"/download/{id}/{name:.+}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u6307\u5b9a\u6587\u4ef6\u540d\u4e0b\u8f7d\u6587\u4ef6")
    @Authorize(action={"download"}, description={"\u4e0b\u8f7d\u6587\u4ef6"})
    public void restDownLoad(@ApiParam(value="\u6587\u4ef6\u7684id\u6216\u8005md5") @PathVariable(value="id") String id, @ApiParam(value="\u6587\u4ef6\u540d") @PathVariable(value="name") String name, @ApiParam(hidden=true) HttpServletResponse response, @ApiParam(hidden=true) HttpServletRequest request) throws IOException {
        this.downLoad(id, name, response, request);
    }

    @GetMapping(value={"/download/{id}"})
    @ApiOperation(value="\u4e0b\u8f7d\u6587\u4ef6")
    @Authorize(action={"download"}, description={"\u4e0b\u8f7d\u6587\u4ef6"})
    public void downLoad(@ApiParam(value="\u6587\u4ef6\u7684id\u6216\u8005md5") @PathVariable(value="id") String idOrMd5, @ApiParam(value="\u6587\u4ef6\u540d,\u5982\u679c\u672a\u6307\u5b9a,\u9ed8\u8ba4\u4e3a\u4e0a\u4f20\u65f6\u7684\u6587\u4ef6\u540d", required=false) @RequestParam(value="name", required=false) String name, @ApiParam(hidden=true) HttpServletResponse response, @ApiParam(hidden=true) HttpServletRequest request) throws IOException {
        String contentType;
        FileInfoEntity fileInfo = this.fileInfoService.selectByIdOrMd5(idOrMd5);
        if (fileInfo == null || !DataStatus.STATUS_ENABLED.equals(fileInfo.getStatus())) {
            throw new NotFoundException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        String fileName = fileInfo.getName();
        String suffix = fileName.contains(".") ? fileName.substring(fileName.lastIndexOf("."), fileName.length()) : "";
        String string = contentType = fileInfo.getType() == null ? MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(fileName) : fileInfo.getType();
        if (StringUtils.isNullOrEmpty((Object)name)) {
            name = fileInfo.getName();
        }
        if (!name.contains(".")) {
            name = name.concat(".").concat(suffix);
        }
        name = fileNameKeyWordPattern.matcher(name).replaceAll("");
        int skip = 0;
        long fSize = fileInfo.getSize();
        try {
            String Range = request.getHeader("Range").replace("bytes=", "").replace("-", "");
            skip = StringUtils.toInt((Object)Range);
        }
        catch (Exception Range) {
            // empty catch block
        }
        response.setContentLength((int)fSize);
        response.setContentType(contentType);
        response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode(name, "utf-8"));
        if (skip > 0) {
            response.setStatus(206);
            String contentRange = "bytes " + skip + "-" + (fSize - 1L) + "/" + fSize;
            response.setHeader("Content-Range", contentRange);
        }
        this.fileService.writeFile(idOrMd5, (OutputStream)response.getOutputStream(), (long)skip);
    }

    @PostMapping(value={"/upload-multi"})
    @ApiOperation(value="\u4e0a\u4f20\u591a\u4e2a\u6587\u4ef6")
    @Authorize(action={"upload"}, description={"\u4e0a\u4f20\u6587\u4ef6"})
    public ResponseMessage<List<FileInfoEntity>> upload(@RequestPart(value="files") MultipartFile[] files) {
        return ResponseMessage.ok(Stream.of(files).map(this::upload).map(ResponseMessage::getResult).collect(Collectors.toList())).include(FileInfoEntity.class, new String[]{"id", "name", "md5", "size", "type"});
    }

    @PostMapping(value={"/upload"})
    @ApiOperation(value="\u4e0a\u4f20\u5355\u4e2a\u6587\u4ef6")
    @Authorize(action={"upload"}, description={"\u4e0a\u4f20\u6587\u4ef6"})
    public ResponseMessage<FileInfoEntity> upload(@RequestPart(value="file") MultipartFile file) {
        FileInfoEntity fileInfo;
        String creator;
        LinkedList<FileInfoEntity> fileInfoList = new LinkedList<FileInfoEntity>();
        Authentication authentication = Authentication.current().orElse(null);
        String string = creator = authentication == null ? null : authentication.getUser().getId();
        if (file.isEmpty()) {
            return ResponseMessage.ok();
        }
        String fileName = file.getOriginalFilename();
        ParameterParser parser = new ParameterParser();
        String contentType = Optional.ofNullable(WebUtil.getHttpServletRequest()).orElseThrow(UnsupportedOperationException::new).getContentType();
        Map params = parser.parse(contentType, ';');
        if (params.get("charset") == null) {
            try {
                fileName = new String(file.getOriginalFilename().getBytes("ISO-8859-1"), "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("start write file:{}", (Object)fileName);
        }
        try {
            fileInfo = this.fileService.saveFile(file.getInputStream(), fileName, file.getContentType(), creator);
        }
        catch (IOException e) {
            throw new BusinessException("save file error", (Throwable)e);
        }
        fileInfoList.add(fileInfo);
        return ResponseMessage.ok((Object)fileInfo).include(FileInfoEntity.class, new String[]{"id", "name", "md5", "size", "type"});
    }

    @PostMapping(value={"/upload-static"})
    @ApiOperation(value="\u4e0a\u4f20\u9759\u6001\u6587\u4ef6", notes="\u4e0a\u4f20\u540e\u54cd\u5e94\u7ed3\u679c\u7684result\u5b57\u6bb5\u4e3a\u6587\u4ef6\u7684\u8bbf\u95ee\u5730\u5740")
    @Authorize(action={"static"}, description={"\u4e0a\u4f20\u9759\u6001\u6587\u4ef6"})
    public ResponseMessage<String> uploadStatic(@RequestPart(value="file") MultipartFile file) throws IOException {
        if (file.isEmpty()) {
            return ResponseMessage.ok();
        }
        return ResponseMessage.ok((Object)this.fileService.saveStaticFile(file.getInputStream(), file.getOriginalFilename()));
    }

    @GetMapping(value={"/md5/{md5}"})
    @ApiOperation(value="\u6839\u636eMD5\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f")
    public ResponseMessage<FileInfoEntity> uploadStatic(@PathVariable String md5) throws IOException {
        return Optional.ofNullable(this.fileInfoService.selectByMd5(md5)).map(ResponseMessage::ok).orElseThrow(() -> new NotFoundException("file not found"));
    }
}

