/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.file.oauth2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.hswebframework.web.authorization.oauth2.client.OAuth2RequestService;
import org.hswebframework.web.authorization.oauth2.client.response.OAuth2Response;
import org.hswebframework.web.entity.file.FileInfoEntity;
import org.hswebframework.web.entity.file.SimpleFileInfoEntity;
import org.hswebframework.web.service.file.FileService;
import org.hswebframework.web.service.oauth2.OAuth2ServiceSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StreamUtils;

@ConfigurationProperties(prefix="hsweb.oauth2.file-server")
public class OAuth2FileService
implements FileService,
OAuth2ServiceSupport {
    private String serviceId = "file-server";
    private String uriPrefix = "file";
    @Autowired
    private OAuth2RequestService requestService;

    public InputStream readFile(String fileIdOrMd5) {
        return (InputStream)this.createRequest("/md5/download/" + fileIdOrMd5).get().as(OAuth2Response::asStream);
    }

    public FileInfoEntity saveFile(InputStream fileStream, String fileName, String type, String creatorId) throws IOException {
        return (FileInfoEntity)this.createRequest("/upload").upload("file", fileStream, fileName).as(this.getEntityType());
    }

    public String saveStaticFile(InputStream fileStream, String fileName) throws IOException {
        return (String)this.createRequest("/upload-static").upload("file", fileStream, fileName).as(String.class);
    }

    public void writeFile(String fileId, OutputStream out, long skip) throws IOException {
        try (InputStream stream = this.createRequest("/download/" + fileId).header("Range", "bytes=" + skip).get().asStream();){
            StreamUtils.copy((InputStream)stream, (OutputStream)out);
        }
    }

    public OAuth2RequestService getRequestService() {
        return this.requestService;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getUriPrefix() {
        return this.uriPrefix;
    }

    public Class<SimpleFileInfoEntity> getEntityType() {
        return SimpleFileInfoEntity.class;
    }

    public Class<String> getPrimaryKeyType() {
        return String.class;
    }
}

