/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.file.simple;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Date;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.hswebframework.utils.time.DateFormatter;
import org.hswebframework.web.NotFoundException;
import org.hswebframework.web.commons.entity.DataStatus;
import org.hswebframework.web.entity.file.FileInfoEntity;
import org.hswebframework.web.service.file.FileInfoService;
import org.hswebframework.web.service.file.FileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StreamUtils;

public class LocalFileService
implements FileService {
    private FileInfoService fileInfoService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String staticFilePath = "./static/upload";
    private String staticLocation = "/upload/";
    private String filePath = "./upload/file";

    @Value(value="${hsweb.web.upload.static-file-path:./static/upload}")
    public void setStaticFilePath(String staticFilePath) {
        this.staticFilePath = staticFilePath;
    }

    @Value(value="${hsweb.web.upload.static-location:/upload/}")
    public void setStaticLocation(String staticLocation) {
        this.staticLocation = staticLocation;
    }

    @Value(value="${hsweb.web.upload.file-path:./upload/file}")
    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getStaticFilePath() {
        return this.staticFilePath;
    }

    public String getStaticLocation() {
        return this.staticLocation;
    }

    @Autowired
    public void setFileInfoService(FileInfoService fileInfoService) {
        this.fileInfoService = fileInfoService;
    }

    public InputStream readFile(String fileIdOrMd5) {
        FileInfoEntity fileInfo = this.fileInfoService.selectByIdOrMd5(fileIdOrMd5);
        if (fileInfo == null || !DataStatus.STATUS_ENABLED.equals(fileInfo.getStatus())) {
            throw new NotFoundException("file not found or disabled");
        }
        String filePath = this.getFilePath() + "/" + fileInfo.getLocation();
        File file = new File(filePath);
        if (!file.exists()) {
            throw new NotFoundException("file not found");
        }
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException ignore) {
            throw new NotFoundException("file not found");
        }
    }

    public String saveStaticFile(InputStream fileStream, String fileName) throws IOException {
        String suffix = fileName.contains(".") ? fileName.substring(fileName.lastIndexOf("."), fileName.length()) : "";
        String filePath = DateFormatter.toString((Date)new Date(), (String)"yyyyMMdd");
        new File(this.getStaticFilePath() + "/" + filePath).mkdirs();
        String realFileName = System.nanoTime() + suffix;
        String fileAbsName = this.getStaticFilePath() + "/" + filePath + "/" + realFileName;
        try (FileOutputStream out = new FileOutputStream(fileAbsName);){
            StreamUtils.copy((InputStream)fileStream, (OutputStream)out);
        }
        return this.getStaticLocation() + filePath + "/" + realFileName;
    }

    public FileInfoEntity saveFile(final InputStream fileStream, String fileName, String type, String creatorId) throws IOException {
        int fileSize;
        String fileBasePath = this.getFilePath();
        String filePath = DateFormatter.toString((Date)new Date(), (String)"yyyyMMdd");
        String absPath = fileBasePath.concat("/").concat(filePath);
        File path = new File(absPath);
        if (!path.exists()) {
            path.mkdirs();
        }
        String newName = String.valueOf(System.nanoTime());
        String fileAbsName = absPath.concat("/").concat(newName);
        final MessageDigest digest = DigestUtils.getMd5Digest();
        try (InputStream proxyStream = new InputStream(){

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int l = fileStream.read(b, off, len);
                digest.update(b, off, len);
                return l;
            }

            @Override
            public void close() throws IOException {
                fileStream.close();
                super.close();
            }

            @Override
            public int available() throws IOException {
                return fileStream.available();
            }

            @Override
            public int read() throws IOException {
                return fileStream.read();
            }
        };
             FileOutputStream os = new FileOutputStream(fileAbsName);){
            int remainBytes = fileSize = proxyStream.available();
            byte[] buff = new byte[remainBytes > 10240 ? 10240 : remainBytes];
            this.logger.info("\u5f00\u59cb\u5199\u51fa\u6587\u4ef6:{}\u5230:{}, size: {} bytes", new Object[]{fileName, fileAbsName, fileSize});
            while (remainBytes > 0) {
                int bytes = proxyStream.read(buff, 0, remainBytes > buff.length ? buff.length : remainBytes);
                os.write(buff, 0, bytes);
                this.logger.info("\u5199\u51fa\u6587\u4ef6:{}:{},\u5269\u4f59\u6570\u636e\u91cf: {} bytes", new Object[]{fileName, fileAbsName, remainBytes -= bytes});
            }
        }
        String md5 = Hex.encodeHexString((byte[])digest.digest());
        File newFile = new File(fileAbsName);
        FileInfoEntity fileInfo = this.fileInfoService.selectByMd5(md5);
        if (fileInfo != null) {
            this.logger.info("\u6587\u4ef6:{}\u5df2\u4e0a\u4f20\u8fc7", (Object)fileAbsName);
            if (new File(this.getFilePath() + "/" + fileInfo.getLocation()).exists()) {
                newFile.delete();
            } else {
                newFile.renameTo(new File(absPath.concat("/").concat(md5)));
            }
            return fileInfo;
        }
        this.logger.info("\u4e0a\u4f20\u6587\u4ef6{}\u5b8c\u6210:{}->{}", new Object[]{fileName, fileAbsName, absPath.concat("/").concat(md5)});
        newFile.renameTo(new File(absPath.concat("/").concat(md5)));
        FileInfoEntity infoEntity = (FileInfoEntity)this.fileInfoService.createEntity();
        infoEntity.setCreateTimeNow();
        infoEntity.setCreatorId(creatorId);
        infoEntity.setLocation(filePath.concat("/").concat(md5));
        infoEntity.setName(fileName);
        infoEntity.setType(type);
        infoEntity.setSize(Long.valueOf(fileSize));
        infoEntity.setMd5(md5);
        infoEntity.setStatus(DataStatus.STATUS_ENABLED);
        this.fileInfoService.insert((Object)infoEntity);
        return infoEntity;
    }

    public void writeFile(String fileId, OutputStream out, long skip) throws IOException {
        try (InputStream inputStream = this.readFile(fileId);){
            if (skip > 0L) {
                long len = inputStream.skip(skip);
                this.logger.info("skip write stream {},{}", (Object)skip, (Object)len);
            }
            StreamUtils.copy((InputStream)inputStream, (OutputStream)out);
        }
    }
}

