/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.file.fastdfs;

import com.luhuiguo.fastdfs.domain.StorePath;
import com.luhuiguo.fastdfs.service.FastFileStorageClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.HashSet;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.hswebframework.web.commons.entity.DataStatus;
import org.hswebframework.web.entity.file.FileInfoEntity;
import org.hswebframework.web.service.file.FileInfoService;
import org.hswebframework.web.service.file.FileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StreamUtils;

public class FdfsFileService
implements FileService {
    private static final Logger log = LoggerFactory.getLogger(FdfsFileService.class);
    private FastFileStorageClient fastFileStorageClient;
    private FileInfoService fileInfoService;
    private String staticLocation = "/";

    @Autowired
    public void setFastFileStorageClient(FastFileStorageClient fastFileStorageClient) {
        this.fastFileStorageClient = fastFileStorageClient;
    }

    @Autowired
    public void setFileInfoService(FileInfoService fileInfoService) {
        this.fileInfoService = fileInfoService;
    }

    public void setStaticLocation(String staticLocation) {
        this.staticLocation = staticLocation;
    }

    public String getStaticLocation() {
        return this.staticLocation;
    }

    public InputStream readFile(String fileIdOrMd5) {
        FileInfoEntity entity = this.fileInfoService.selectByIdOrMd5(fileIdOrMd5);
        StorePath path = StorePath.praseFromUrl((String)entity.getLocation());
        return (InputStream)this.fastFileStorageClient.downloadFile(path.getGroup(), path.getPath(), ins -> ins);
    }

    public FileInfoEntity saveFile(final InputStream fileStream, String fileName, String type, String creatorId) throws IOException {
        StorePath path;
        int fileSize;
        final MessageDigest digest = DigestUtils.getMd5Digest();
        String suffix = fileName.contains(".") ? fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length()) : "";
        try (InputStream tmp = new InputStream(){

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int r = super.read(b, off, len);
                digest.update(b, off, len);
                return r;
            }

            @Override
            public int read() throws IOException {
                return fileStream.read();
            }

            @Override
            public void close() throws IOException {
                fileStream.close();
                super.close();
            }

            @Override
            public int available() throws IOException {
                return fileStream.available();
            }
        };){
            fileSize = tmp.available();
            path = this.fastFileStorageClient.uploadFile(tmp, (long)fileSize, suffix, new HashSet());
        }
        String md5 = Hex.encodeHexString((byte[])digest.digest());
        FileInfoEntity fileInfo = (FileInfoEntity)this.fileInfoService.createEntity();
        fileInfo.setLocation(path.getFullPath());
        fileInfo.setMd5(md5);
        fileInfo.setStatus(DataStatus.STATUS_ENABLED);
        fileInfo.setSize(Long.valueOf(fileSize));
        fileInfo.setName(fileName);
        fileInfo.setType(type);
        fileInfo.setCreatorId(creatorId);
        fileInfo.setCreateTimeNow();
        this.fileInfoService.insert((Object)fileInfo);
        return fileInfo;
    }

    public String saveStaticFile(InputStream fileStream, String fileName) throws IOException {
        String suffix = fileName.contains(".") ? fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length()) : "";
        StorePath path = this.fastFileStorageClient.uploadFile(fileStream, (long)fileStream.available(), suffix, new HashSet());
        return this.staticLocation.concat(path.getFullPath());
    }

    public void writeFile(String fileId, OutputStream out, long skip) throws IOException {
        try (InputStream inputStream = this.readFile(fileId);){
            if (skip > 0L) {
                long len = inputStream.skip(skip);
                log.info("skip write {} len:{}", (Object)skip, (Object)len);
            }
            StreamUtils.copy((InputStream)inputStream, (OutputStream)out);
        }
    }
}

