/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.file.simple;

import java.util.List;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.web.commons.entity.GenericEntity;
import org.hswebframework.web.dao.file.FileInfoDao;
import org.hswebframework.web.entity.file.FileInfoEntity;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.service.GenericEntityService;
import org.hswebframework.web.service.file.FileInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.stereotype.Service;

@Service(value="fileInfoService")
@CacheConfig(cacheNames={"file-info"})
public class SimpleFileInfoService
extends GenericEntityService<FileInfoEntity, String>
implements FileInfoService {
    private FileInfoDao fileInfoDao;

    protected IDGenerator<String> getIDGenerator() {
        return IDGenerator.MD5;
    }

    public FileInfoDao getDao() {
        return this.fileInfoDao;
    }

    @Autowired
    public void setFileInfoDao(FileInfoDao fileInfoDao) {
        this.fileInfoDao = fileInfoDao;
    }

    @Caching(evict={@CacheEvict(key="'md5:'+#entity.md5"), @CacheEvict(key="'id:'+#result"), @CacheEvict(key="'id-or-md5:'+#result"), @CacheEvict(key="'id-or-md5:'+#result")})
    public String insert(FileInfoEntity entity) {
        return (String)super.insert((GenericEntity)entity);
    }

    @Caching(evict={@CacheEvict(key="'md5:'+#entity.md5"), @CacheEvict(key="'id:'+#entity.id"), @CacheEvict(key="'id-or-md5:'+#entity.id"), @CacheEvict(key="'id-or-md5:'+#entity.id")})
    protected int updateByPk(FileInfoEntity entity) {
        return super.updateByPk((GenericEntity)entity);
    }

    @Caching(evict={@CacheEvict(key="'md5:'+#result.md5", condition="#result!=null"), @CacheEvict(key="'id:'+#id"), @CacheEvict(key="'id-or-md5:'+#id"), @CacheEvict(key="'id-or-md5:'+#id")})
    public FileInfoEntity deleteByPk(String id) {
        return (FileInfoEntity)super.deleteByPk((Object)id);
    }

    @CacheEvict(allEntries=true)
    public int updateByPk(List<FileInfoEntity> data) {
        return super.updateByPk(data);
    }

    @Cacheable(key="'id:'+#id", condition="#id!=null")
    public FileInfoEntity selectByPk(String id) {
        return (FileInfoEntity)super.selectByPk((Object)id);
    }

    @Cacheable(key="'md5:'+#md5", condition="#md5!=null")
    public FileInfoEntity selectByMd5(String md5) {
        if (null == md5) {
            return null;
        }
        return (FileInfoEntity)((Query)this.createQuery().where("md5", (Object)md5)).single();
    }

    @Cacheable(key="'id-or-md5:'+#idOrMd5", condition="#idOrMd5!=null")
    public FileInfoEntity selectByIdOrMd5(String idOrMd5) {
        if (null == idOrMd5) {
            return null;
        }
        return (FileInfoEntity)((Query)((Query)this.createQuery().where("md5", (Object)idOrMd5)).or("id", (Object)idOrMd5)).single();
    }
}

