/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.form.simple;

import java.util.Objects;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.ezorm.core.dsl.Update;
import org.hswebframework.web.commons.entity.DataStatus;
import org.hswebframework.web.dao.form.DynamicFormDeployLogDao;
import org.hswebframework.web.entity.form.DynamicFormDeployLogEntity;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.service.GenericEntityService;
import org.hswebframework.web.service.form.DynamicFormDeployLogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dynamicFormDeployLogService")
public class SimpleDynamicFormDeployLogService
extends GenericEntityService<DynamicFormDeployLogEntity, String>
implements DynamicFormDeployLogService {
    @Autowired
    private DynamicFormDeployLogDao dynamicFormDeployLogDao;

    protected IDGenerator<String> getIDGenerator() {
        return IDGenerator.MD5;
    }

    public DynamicFormDeployLogDao getDao() {
        return this.dynamicFormDeployLogDao;
    }

    public DynamicFormDeployLogEntity selectLastDeployed(String formId) {
        Objects.requireNonNull(formId);
        DynamicFormDeployLogEntity deployed = (DynamicFormDeployLogEntity)((Query)this.createQuery().where("formId", (Object)formId)).orderByDesc("deployTime").single();
        if (null != deployed && DataStatus.STATUS_ENABLED.equals(deployed.getStatus())) {
            return deployed;
        }
        return null;
    }

    public DynamicFormDeployLogEntity selectDeployed(String formId, long version) {
        Objects.requireNonNull(formId);
        DynamicFormDeployLogEntity deployed = (DynamicFormDeployLogEntity)((Query)((Query)this.createQuery().where("formId", (Object)formId)).and("version", (Object)version)).orderByDesc("deployTime").single();
        if (null != deployed && DataStatus.STATUS_ENABLED.equals(deployed.getStatus())) {
            return deployed;
        }
        return null;
    }

    public void cancelDeployed(String formId) {
        Objects.requireNonNull(formId);
        DynamicFormDeployLogEntity deployed = (DynamicFormDeployLogEntity)((Query)this.createQuery().where("formId", (Object)formId)).orderByDesc("deployTime").single();
        if (deployed != null) {
            ((Update)this.createUpdate().set("status", (Object)DataStatus.STATUS_DISABLED).where("id", deployed.getId())).exec();
        }
    }

    public void cancelDeployed(String formId, long version) {
        Objects.requireNonNull(formId);
        ((Update)((Update)this.createUpdate().set("status", (Object)DataStatus.STATUS_DISABLED).where("formId", (Object)formId)).and("version", (Object)version)).exec();
    }
}

