/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.form.simple.dict;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hswebframework.ezorm.core.OptionConverter;
import org.hswebframework.web.dict.EnumDict;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumDictOptionConverter<T extends EnumDict>
implements OptionConverter {
    private static final Logger log = LoggerFactory.getLogger(EnumDictOptionConverter.class);
    protected Supplier<List<T>> allOptionSupplier;
    protected Function<Stream<String>, String> dictToText = stream -> stream.collect(Collectors.joining(","));
    protected Function<String, List<Object>> splitter = str -> Arrays.asList(str.split("[, ; \uff1b]"));
    protected boolean writeObject;
    protected String fieldName;

    public EnumDictOptionConverter(Supplier<List<T>> supplier, String fieldName) {
        this.allOptionSupplier = supplier;
        this.fieldName = fieldName;
    }

    public Object getOptions() {
        return this.allOptionSupplier.get();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object converterData(Object o) {
        return o;
    }

    public Object converterValue(Object o) {
        List<Object> values = o instanceof String ? this.splitter.apply((String)o) : (o instanceof Object[] ? Arrays.asList((Object[])o) : (o instanceof Collection ? new ArrayList<Object>((Collection)o) : Collections.singletonList(o)));
        if (this.writeObject) {
            return this.allOptionSupplier.get().stream().filter(e -> e.eq((Object)values)).collect(Collectors.toSet());
        }
        return this.dictToText.apply(this.allOptionSupplier.get().stream().filter(e -> e.eq((Object)values)).map(EnumDict::getText).map(String::valueOf));
    }

    public Function<Stream<String>, String> getDictToText() {
        return this.dictToText;
    }

    public void setDictToText(Function<Stream<String>, String> dictToText) {
        this.dictToText = dictToText;
    }

    public void setSplitter(Function<String, List<Object>> splitter) {
        this.splitter = splitter;
    }

    public Function<String, List<Object>> getSplitter() {
        return this.splitter;
    }

    public boolean isWriteObject() {
        return this.writeObject;
    }

    public void setWriteObject(boolean writeObject) {
        this.writeObject = writeObject;
    }
}

