/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.form.simple.dict;

import com.alibaba.fastjson.JSONObject;
import java.sql.JDBCType;
import java.util.Arrays;
import java.util.function.Supplier;
import org.hswebframework.ezorm.core.OptionConverter;
import org.hswebframework.ezorm.core.ValueConverter;
import org.hswebframework.ezorm.rdb.meta.RDBColumnMetaData;
import org.hswebframework.web.dict.DictDefineRepository;
import org.hswebframework.web.entity.form.DictConfig;
import org.hswebframework.web.service.form.simple.dict.EnumDictOptionConverter;
import org.hswebframework.web.service.form.simple.dict.EnumDictValueConverter;
import org.hswebframework.web.service.form.simple.dict.OptionalConvertBuilderStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class DictionaryOptionalConvertBuilderStrategy
implements OptionalConvertBuilderStrategy {
    @Autowired(required=false)
    private DictDefineRepository dictDefineRepository;

    @Override
    public boolean support(String type) {
        return "dict".equals(type) && this.dictDefineRepository != null;
    }

    @Override
    public OptionConverter build(DictConfig dictConfig) {
        JSONObject conf = new JSONObject(dictConfig.getConfig());
        String dictId = conf.getString("dictId");
        String fieldName = dictConfig.getToField();
        String sppliter = conf.getString("spliter");
        String writeObject = conf.getString("writeObject");
        EnumDictOptionConverter converter = new EnumDictOptionConverter(() -> this.dictDefineRepository.getDefine(dictId).getItems(), fieldName);
        converter.setWriteObject(!"false".equalsIgnoreCase(writeObject));
        if (!StringUtils.isEmpty((Object)sppliter)) {
            converter.setSplitter(str -> Arrays.asList(str.split(sppliter)));
        }
        return converter;
    }

    @Override
    public ValueConverter buildValueConverter(DictConfig dictConfig) {
        JSONObject conf = new JSONObject(dictConfig.getConfig());
        String dictId = conf.getString("dictId");
        boolean multi = !"false".equalsIgnoreCase(conf.getString("multi"));
        Supplier supplier = () -> this.dictDefineRepository.getDefine(dictId).getItems();
        EnumDictValueConverter converter = new EnumDictValueConverter(supplier);
        converter.setMulti(multi);
        RDBColumnMetaData column = dictConfig.getColumn();
        if (multi && (column.getJdbcType() == JDBCType.NUMERIC || column.getJdbcType() == JDBCType.BIGINT)) {
            if (supplier.get().size() < 64) {
                column.setProperty("dict-mask", (Object)true);
                converter.setDataToMask(true);
            } else {
                throw new UnsupportedOperationException("\u6570\u636e\u7c7b\u578b\u4e3a\u6570\u5b57,\u5e76\u4e14\u6570\u636e\u5b57\u5178\u9009\u9879\u6570\u91cf\u8d85\u8fc764\u4e2a,\u4e0d\u652f\u6301\u591a\u9009!");
            }
        }
        return converter;
    }
}

