/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.form.simple.cluster;

import java.util.function.Consumer;
import java.util.function.Function;
import org.hswebframework.ezorm.rdb.RDBTable;
import org.hswebframework.ezorm.rdb.executor.SqlExecutor;
import org.hswebframework.ezorm.rdb.meta.RDBDatabaseMetaData;
import org.hswebframework.ezorm.rdb.meta.RDBTableMetaData;
import org.hswebframework.ezorm.rdb.simple.SimpleDatabase;

public class ClusterDatabase
extends SimpleDatabase {
    private volatile Consumer<RDBTableMetaData> versionChanged;
    private volatile Function<RDBTableMetaData, Long> latestVersionGetter;

    public ClusterDatabase(RDBDatabaseMetaData metaData, SqlExecutor sqlExecutor) {
        super(metaData, sqlExecutor);
    }

    public void setVersionChanged(Consumer<RDBTableMetaData> versionChanged) {
        this.versionChanged = versionChanged;
    }

    public void setLatestVersionGetter(Function<RDBTableMetaData, Long> latestVersionGetter) {
        this.latestVersionGetter = latestVersionGetter;
    }

    public <T> RDBTable<T> getTable(String name) {
        RDBTable table = super.getTable(name);
        if (this.versionChanged == null || this.latestVersionGetter == null) {
            return table;
        }
        if (table != null) {
            long version = (Long)table.getMeta().getProperty("version", (Object)-1L).getValue();
            if (version == -1L) {
                return table;
            }
            if (version != this.latestVersionGetter.apply(table.getMeta())) {
                this.versionChanged.accept(table.getMeta());
            }
            return super.getTable(name);
        }
        return null;
    }
}

