/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.form.simple.validator.jsr303;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.service.form.simple.validator.JSR303AnnotationInfo;
import org.hswebframework.web.service.form.simple.validator.JSR303AnnotationParserStrategy;
import org.hswebframework.web.validator.group.CreateGroup;
import org.hswebframework.web.validator.group.UpdateGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractStrategy
implements JSR303AnnotationParserStrategy {
    private static final Logger log = LoggerFactory.getLogger(AbstractStrategy.class);
    private List<PropertyMapping> propertyMappings = new ArrayList<PropertyMapping>();

    public AbstractStrategy() {
        this.propertyMappings.add(PropertyMapping.of("message", String.class));
    }

    public void addPropertyMapping(PropertyMapping mapping) {
        this.propertyMappings.add(mapping);
    }

    protected String getTypeString() {
        return this.getAnnotationType().getSimpleName();
    }

    protected abstract Class<? extends Annotation> getAnnotationType();

    @Override
    public boolean support(String type) {
        return type != null && this.getTypeString().equalsIgnoreCase(type);
    }

    @Override
    public JSR303AnnotationInfo parse(Map<String, Object> configMap) {
        JSR303AnnotationInfo info = new JSR303AnnotationInfo();
        info.setAnnotation(this.getAnnotationType());
        HashMap<String, Object> properties = new HashMap<String, Object>();
        this.propertyMappings.forEach(mapping -> {
            Object value = mapping.getConverter().apply(configMap.get(mapping.getName()));
            if (!StringUtils.isEmpty(value)) {
                properties.put(mapping.getName(), value);
            }
        });
        Object groups = null;
        Object groupObject = new JSONObject(configMap).get((Object)"groups");
        if (groupObject instanceof JSONArray) {
            groups = (JSONArray)groupObject;
        }
        if (groupObject instanceof String) {
            groups = Arrays.asList(((String)groupObject).split("[,]"));
        }
        if (!CollectionUtils.isEmpty((Collection)groups)) {
            properties.put("groups", groups.stream().map(obj -> {
                if ("create".equals(obj)) {
                    return CreateGroup.class;
                }
                if ("update".equals(obj)) {
                    return UpdateGroup.class;
                }
                try {
                    return ClassUtils.forName((String)String.valueOf(obj), null);
                }
                catch (ClassNotFoundException e) {
                    return CreateGroup.class;
                }
            }).toArray());
        }
        info.setProperties(properties);
        return info;
    }

    public static class PropertyMapping<T> {
        private String name;
        private Class<T> type;
        private Function<Object, T> converter = source -> FastBeanCopier.DEFAULT_CONVERT.convert(source, this.type, null);

        public static <T> PropertyMapping<T> of(String name, Class<T> type) {
            PropertyMapping<T> mapping = new PropertyMapping<T>();
            mapping.name = name;
            mapping.type = type;
            return mapping;
        }

        public static <T> PropertyMapping<T> of(String name, Class<T> type, Function<Object, T> converter) {
            PropertyMapping<T> mapping = new PropertyMapping<T>();
            mapping.name = name;
            mapping.type = type;
            mapping.converter = converter;
            return mapping;
        }

        public String getName() {
            return this.name;
        }

        public Class<T> getType() {
            return this.type;
        }

        public Function<Object, T> getConverter() {
            return this.converter;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setType(Class<T> type) {
            this.type = type;
        }

        public void setConverter(Function<Object, T> converter) {
            this.converter = converter;
        }
    }
}

