/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.form.simple.validator;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javassist.CtClass;
import javassist.CtField;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.MemberValue;
import org.hswebframework.ezorm.core.Validator;
import org.hswebframework.ezorm.core.ValidatorFactory;
import org.hswebframework.ezorm.core.meta.ColumnMetaData;
import org.hswebframework.ezorm.core.meta.TableMetaData;
import org.hswebframework.utils.StringUtils;
import org.hswebframework.web.proxy.Proxy;
import org.hswebframework.web.service.form.simple.validator.DynamicBeanValidator;
import org.hswebframework.web.service.form.simple.validator.JSR303AnnotationInfo;
import org.hswebframework.web.service.form.simple.validator.JSR303AnnotationParserStrategy;
import org.hswebframework.web.service.form.simple.validator.MapBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Component
public class DynamicBeanValidatorFactory
implements ValidatorFactory {
    private static final Logger log = LoggerFactory.getLogger(DynamicBeanValidatorFactory.class);
    @Autowired
    private List<JSR303AnnotationParserStrategy> strategies;

    private String createSetPropertyCode(TableMetaData tableMetaData) {
        StringBuilder builder = new StringBuilder();
        builder.append("public void setProperty(String property,Object value){\n");
        int index = 0;
        for (ColumnMetaData column : tableMetaData.getColumns()) {
            String propertyName = column.getAlias();
            Class type = column.getJavaType();
            if (index++ > 0) {
                builder.append("\nelse ");
            }
            builder.append("if(property.intern()==\"").append(propertyName).append("\"||property.intern()==\"").append(column.getName()).append("\"){\n").append("this.set").append(StringUtils.toUpperCaseFirstOne((String)propertyName)).append("((").append(type.getName()).append(")").append("org.hswebframework.web.bean.FastBeanCopier.DEFAULT_CONVERT.convert(value,").append(type.getName()).append(".class,null));").append("\n}");
        }
        builder.append("}");
        return builder.toString();
    }

    private String createGetPropertyCode(TableMetaData tableMetaData) {
        StringBuilder builder = new StringBuilder();
        int index = 0;
        builder.append("public Object getProperty(String property){\n");
        for (ColumnMetaData column : tableMetaData.getColumns()) {
            String propertyName = column.getAlias();
            if (index++ > 0) {
                builder.append("\nelse ");
            }
            builder.append("if(property.intern()==\"").append(propertyName).append("\"||property.intern()==\"").append(column.getName()).append("\"){\n").append("return this.get").append(StringUtils.toUpperCaseFirstOne((String)propertyName)).append("();").append("\n}");
        }
        builder.append("\nreturn null;\n}");
        return builder.toString();
    }

    protected List<JSR303AnnotationInfo> createValidatorAnnotation(Set<String> config) {
        if (CollectionUtils.isEmpty(config)) {
            return new ArrayList<JSR303AnnotationInfo>();
        }
        return config.stream().map(this::createValidatorAnnotation).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected JSR303AnnotationInfo createValidatorAnnotation(String config) {
        if (config.startsWith("{")) {
            JSONObject jsonConfig = JSON.parseObject((String)config);
            String type = jsonConfig.getString("type");
            return this.strategies.stream().filter(strategy -> strategy.support(type)).findFirst().map(strategy -> strategy.parse((Map<String, Object>)jsonConfig)).orElse(null);
        }
        return null;
    }

    public Validator createValidator(TableMetaData tableMetaData) {
        Proxy proxy = Proxy.create(MapBean.class, (String[])new String[0]);
        StringBuilder keySet = new StringBuilder("public java.util.Set keySet(){\n return new java.util.HashSet(java.util.Arrays.asList(new String[]{");
        int index = 0;
        for (ColumnMetaData column : tableMetaData.getColumns()) {
            String propertyName = column.getAlias();
            Class type = column.getJavaType();
            String typeName = type.getName();
            if (index++ > 0) {
                keySet.append(",");
            }
            keySet.append("\"").append(propertyName).append("\"");
            proxy.custom(ctClass -> {
                try {
                    CtField ctField = CtField.make((String)("private " + type.getName() + " " + propertyName + ";"), (CtClass)ctClass);
                    List<JSR303AnnotationInfo> jsr303 = this.createValidatorAnnotation(column.getValidator());
                    if (!CollectionUtils.isEmpty(jsr303)) {
                        ConstPool constPool = ctClass.getClassFile().getConstPool();
                        AnnotationsAttribute attributeInfo = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
                        for (JSR303AnnotationInfo jsr303AnnotationInfo : jsr303) {
                            Class<? extends Annotation> jsr303Ann = jsr303AnnotationInfo.getAnnotation();
                            javassist.bytecode.annotation.Annotation ann = new javassist.bytecode.annotation.Annotation(jsr303Ann.getName(), constPool);
                            if (!CollectionUtils.isEmpty(jsr303AnnotationInfo.getProperties())) {
                                jsr303AnnotationInfo.getProperties().forEach((key, value) -> {
                                    MemberValue memberValue = Proxy.createMemberValue((Object)value, (ConstPool)constPool);
                                    if (memberValue != null) {
                                        ann.addMemberValue(key, memberValue);
                                    }
                                });
                            }
                            attributeInfo.addAnnotation(ann);
                        }
                        ctField.getFieldInfo().addAttribute((AttributeInfo)attributeInfo);
                    }
                    ctClass.addField(ctField);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            proxy.addMethod("public void set" + StringUtils.toUpperCaseFirstOne((String)propertyName) + "(" + typeName + " " + propertyName + "){\nthis." + propertyName + "=" + propertyName + ";\n\n};");
            proxy.addMethod("public " + typeName + " get" + StringUtils.toUpperCaseFirstOne((String)propertyName) + "(){\nreturn this." + propertyName + ";\n\n};");
        }
        keySet.append("}));\n}");
        proxy.addMethod(keySet.toString());
        proxy.addMethod(this.createSetPropertyCode(tableMetaData));
        proxy.addMethod(this.createGetPropertyCode(tableMetaData));
        MapBean mapBean = (MapBean)proxy.newInstance();
        Assert.notNull((Object)mapBean, (String)"\u521b\u5efa\u9a8c\u8bc1\u5668\u5931\u8d25!");
        return new DynamicBeanValidator(() -> ((Proxy)proxy).newInstance());
    }
}

