/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.form.simple.dict;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hswebframework.ezorm.core.ValueConverter;
import org.hswebframework.utils.StringUtils;
import org.hswebframework.web.dict.EnumDict;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumDictValueConverter<T extends EnumDict>
implements ValueConverter {
    private static final Logger log = LoggerFactory.getLogger(EnumDictValueConverter.class);
    protected Supplier<List<T>> allOptionSupplier;
    protected Function<Object, T> orElseGet = v -> {
        log.warn("\u9009\u9879[{}]\u5728\u5b57\u5178\u4e2d\u4e0d\u5b58\u5728.\u5168\u90e8\u9009\u9879:[{}]", v, this.allOptionSupplier.get());
        return null;
    };
    protected Function<Stream<String>, String> multiValueConvert = stream -> stream.collect(Collectors.joining(","));
    protected Function<String, List<Object>> splitter = str -> Arrays.asList(str.split("[, ; \uff1b]"));
    private boolean multi = true;
    private boolean dataToMask = true;

    public EnumDictValueConverter(Supplier<List<T>> allOptionSupplier) {
        this.allOptionSupplier = allOptionSupplier;
    }

    public EnumDictValueConverter(Supplier<List<T>> allOptionSupplier, Function<Object, T> orElseGet) {
        this.allOptionSupplier = allOptionSupplier;
        this.orElseGet = orElseGet;
    }

    protected T find(Object value) {
        return (T)this.allOptionSupplier.get().stream().filter(e -> e.eq(value)).findFirst().orElseGet(() -> (EnumDict)this.orElseGet.apply(value));
    }

    public Object getData(Object value) {
        if (org.springframework.util.StringUtils.isEmpty((Object)value)) {
            return value;
        }
        if (this.multi) {
            List<Object> values = value instanceof String ? this.splitter.apply((String)value) : (value instanceof Object[] ? Arrays.asList((Object[])value) : (value instanceof Collection ? new ArrayList<Object>((Collection)value) : Collections.singletonList(value)));
            if (this.dataToMask) {
                if (value instanceof Number) {
                    return ((Number)value).longValue();
                }
                return EnumDict.toMask((EnumDict[])((EnumDict[])values.stream().map(this::find).filter(Objects::nonNull).toArray(EnumDict[]::new)));
            }
            return this.multiValueConvert.apply(values.stream().map(this::find).filter(Objects::nonNull).map(EnumDict::getValue).map(String::valueOf));
        }
        return Optional.ofNullable(this.find(value)).map(EnumDict::getValue).orElse(value);
    }

    public Object getValue(Object data) {
        if (this.multi) {
            if (this.dataToMask) {
                Long mask = null;
                if (StringUtils.isNumber((Object)data)) {
                    mask = StringUtils.toLong((Object)data);
                }
                if (mask != null) {
                    return this.multiValueConvert.apply(EnumDict.getByMask(this.allOptionSupplier, (long)mask).stream().map(EnumDict::getValue).map(String::valueOf));
                }
            }
            List<Object> lst = this.splitter.apply(String.valueOf(data));
            return this.multiValueConvert.apply(this.allOptionSupplier.get().stream().filter(e -> e.eq((Object)lst)).map(EnumDict::getValue).map(String::valueOf));
        }
        return data;
    }

    public Function<Stream<String>, String> getMultiValueConvert() {
        return this.multiValueConvert;
    }

    public void setMultiValueConvert(Function<Stream<String>, String> multiValueConvert) {
        this.multiValueConvert = multiValueConvert;
    }

    public void setSplitter(Function<String, List<Object>> splitter) {
        this.splitter = splitter;
    }

    public Function<String, List<Object>> getSplitter() {
        return this.splitter;
    }

    public void setMulti(boolean multi) {
        this.multi = multi;
    }

    public boolean isMulti() {
        return this.multi;
    }

    public void setDataToMask(boolean dataToMask) {
        this.dataToMask = dataToMask;
    }

    public boolean isDataToMask() {
        return this.dataToMask;
    }
}

