/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.form.simple;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.hswebframework.expands.script.engine.DynamicScriptEngine;
import org.hswebframework.expands.script.engine.DynamicScriptEngineFactory;
import org.hswebframework.ezorm.core.ObjectWrapperFactory;
import org.hswebframework.ezorm.core.Trigger;
import org.hswebframework.ezorm.core.ValidatorFactory;
import org.hswebframework.ezorm.core.ValueConverter;
import org.hswebframework.ezorm.core.dsl.Delete;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.ezorm.core.dsl.Update;
import org.hswebframework.ezorm.core.meta.TableMetaData;
import org.hswebframework.ezorm.rdb.RDBDatabase;
import org.hswebframework.ezorm.rdb.meta.Correlation;
import org.hswebframework.ezorm.rdb.meta.RDBColumnMetaData;
import org.hswebframework.ezorm.rdb.meta.RDBTableMetaData;
import org.hswebframework.ezorm.rdb.meta.converter.BlobValueConverter;
import org.hswebframework.ezorm.rdb.meta.converter.ClobValueConverter;
import org.hswebframework.ezorm.rdb.meta.converter.DateTimeConverter;
import org.hswebframework.ezorm.rdb.meta.converter.DefaultValueConverter;
import org.hswebframework.ezorm.rdb.meta.converter.JSONValueConverter;
import org.hswebframework.ezorm.rdb.meta.converter.NumberValueConverter;
import org.hswebframework.ezorm.rdb.render.dialect.Dialect;
import org.hswebframework.ezorm.rdb.simple.trigger.ScriptTraggerSupport;
import org.hswebframework.web.BusinessException;
import org.hswebframework.web.commons.entity.DataStatus;
import org.hswebframework.web.commons.entity.GenericEntity;
import org.hswebframework.web.dao.dynamic.DeleteByEntityDao;
import org.hswebframework.web.dao.dynamic.QueryByEntityDao;
import org.hswebframework.web.dao.dynamic.UpdateByEntityDao;
import org.hswebframework.web.dao.form.DynamicFormColumnDao;
import org.hswebframework.web.dao.form.DynamicFormDao;
import org.hswebframework.web.dict.EnumDict;
import org.hswebframework.web.entity.form.DictConfig;
import org.hswebframework.web.entity.form.DynamicFormColumnBindEntity;
import org.hswebframework.web.entity.form.DynamicFormColumnEntity;
import org.hswebframework.web.entity.form.DynamicFormDeployLogEntity;
import org.hswebframework.web.entity.form.DynamicFormEntity;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.service.DefaultDSLDeleteService;
import org.hswebframework.web.service.DefaultDSLQueryService;
import org.hswebframework.web.service.DefaultDSLUpdateService;
import org.hswebframework.web.service.GenericEntityService;
import org.hswebframework.web.service.form.DatabaseRepository;
import org.hswebframework.web.service.form.DynamicFormDeployLogService;
import org.hswebframework.web.service.form.DynamicFormService;
import org.hswebframework.web.service.form.FormDeployService;
import org.hswebframework.web.service.form.OptionalConvertBuilder;
import org.hswebframework.web.service.form.events.FormDeployEvent;
import org.hswebframework.web.service.form.initialize.ColumnInitializeContext;
import org.hswebframework.web.service.form.initialize.DynamicFormInitializeCustomizer;
import org.hswebframework.web.service.form.initialize.TableInitializeContext;
import org.hswebframework.web.service.form.simple.DynamicFormException;
import org.hswebframework.web.service.form.simple.dict.EnumDictValueConverter;
import org.hswebframework.web.validator.group.CreateGroup;
import org.hswebframework.web.validator.group.UpdateGroup;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="dynamicFormService")
@CacheConfig(cacheNames={"dyn-form"})
public class SimpleDynamicFormService
extends GenericEntityService<DynamicFormEntity, String>
implements DynamicFormService,
FormDeployService {
    @Value(value="${hsweb.dynamic-form.tags:none}")
    private String[] tags;
    @Value(value="${hsweb.dynamic-form.tag:none}")
    private String tag;
    @Value(value="${hsweb.dynamic-form.load-only-tags:null}")
    private String[] loadOnlyTags;
    @Autowired
    private DynamicFormDao dynamicFormDao;
    @Autowired
    private DynamicFormColumnDao formColumnDao;
    @Autowired
    private DatabaseRepository databaseRepository;
    @Autowired
    private DynamicFormDeployLogService dynamicFormDeployLogService;
    @Autowired(required=false)
    private OptionalConvertBuilder optionalConvertBuilder;
    @Autowired(required=false)
    private List<DynamicFormInitializeCustomizer> initializeCustomizers;
    @Autowired
    private ValidatorFactory validatorFactory;
    @Autowired(required=false)
    private ObjectWrapperFactory objectWrapperFactory;
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    private static final Map<String, Class> classMapping = new HashMap<String, Class>();

    protected IDGenerator<String> getIDGenerator() {
        return IDGenerator.MD5;
    }

    public DynamicFormDao getDao() {
        return this.dynamicFormDao;
    }

    @Caching(evict={@CacheEvict(value={"dyn-form-deploy"}, allEntries=true), @CacheEvict(value={"dyn-form"}, allEntries=true)})
    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void deployAllFromLog() {
        ArrayList<String> tags = new ArrayList<String>(Arrays.asList(this.tags));
        if (this.loadOnlyTags != null) {
            tags.addAll(Arrays.asList(this.loadOnlyTags));
        }
        List entities = ((Query)((Query)this.createQuery().select(new String[]{"id"}).where("deployed", (Object)true)).and().in("tags", tags)).listNoPaging();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("do deploy all form , size:{}", (Object)entities.size());
        }
        for (DynamicFormEntity form : entities) {
            DynamicFormDeployLogEntity logEntity = this.dynamicFormDeployLogService.selectLastDeployed((String)form.getId());
            if (null == logEntity) continue;
            this.deployFromLog(logEntity);
        }
    }

    @Caching(evict={@CacheEvict(value={"dyn-form-deploy"}, allEntries=true), @CacheEvict(value={"dyn-form"}, allEntries=true)})
    public void deployAll() {
        this.createQuery().select(new String[]{"id"}).listNoPaging().forEach(form -> this.deploy((String)form.getId()));
    }

    public DynamicFormDeployLogEntity createDeployLog(DynamicFormEntity form, List<DynamicFormColumnEntity> columns) {
        DynamicFormDeployLogEntity entity = (DynamicFormDeployLogEntity)this.entityFactory.newInstance(DynamicFormDeployLogEntity.class);
        entity.setStatus(DataStatus.STATUS_ENABLED);
        entity.setDeployTime(Long.valueOf(System.currentTimeMillis()));
        entity.setVersion(form.getVersion());
        entity.setFormId((String)form.getId());
        DynamicFormColumnBindEntity bindEntity = new DynamicFormColumnBindEntity();
        bindEntity.setForm(form);
        bindEntity.setColumns(columns);
        entity.setMetaData(JSON.toJSONString((Object)bindEntity));
        return entity;
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void deployFromLog(DynamicFormDeployLogEntity logEntity) {
        DynamicFormColumnBindEntity entity = (DynamicFormColumnBindEntity)JSON.parseObject((String)logEntity.getMetaData(), DynamicFormColumnBindEntity.class);
        DynamicFormEntity form = entity.getForm();
        List columns = entity.getColumns();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("do deploy form {} , columns size:{}", (Object)form.getName(), (Object)columns.size());
        }
        this.deploy(form, columns, this.loadOnlyTags == null || !Arrays.asList(this.loadOnlyTags).contains(entity.getForm().getTags()));
    }

    @CacheEvict(key="'form_id:'+#entity.id")
    public String insert(DynamicFormEntity entity) {
        entity.setDeployed(Boolean.valueOf(false));
        entity.setVersion(Long.valueOf(1L));
        entity.setCreateTime(Long.valueOf(System.currentTimeMillis()));
        entity.setTags(this.tag);
        return (String)super.insert((GenericEntity)entity);
    }

    @Cacheable(key="'form_id:'+#id")
    public DynamicFormEntity selectByPk(String id) {
        return (DynamicFormEntity)super.selectByPk((Object)id);
    }

    @CacheEvict(key="'form_id:'+#id")
    public int updateByPk(String id, DynamicFormEntity entity) {
        entity.setVersion(null);
        entity.setDeployed(null);
        entity.setUpdateTime(Long.valueOf(System.currentTimeMillis()));
        this.getDao().incrementVersion(id);
        return super.updateByPk((Object)id, (GenericEntity)entity);
    }

    protected void initDatabase(RDBDatabase database) {
    }

    @Caching(evict={@CacheEvict(value={"dyn-form-deploy"}, allEntries=true), @CacheEvict(value={"dyn-form"}, allEntries=true)})
    public void unDeploy(String formId) {
        DynamicFormEntity form = this.selectByPk(formId);
        SimpleDynamicFormService.assertNotNull((Object)form);
        this.dynamicFormDeployLogService.cancelDeployed(formId);
        RDBDatabase database = StringUtils.isEmpty((Object)form.getDataSourceId()) ? this.databaseRepository.getDefaultDatabase(form.getDatabaseName()) : this.databaseRepository.getDatabase(form.getDataSourceId(), form.getDatabaseName());
        database.removeTable(form.getDatabaseTableName());
        ((Update)this.createUpdate().set("deployed", (Object)false).where("id", (Object)formId)).exec();
        this.eventPublisher.publishEvent((Object)new FormDeployEvent(formId));
    }

    private String saveOrUpdate0(DynamicFormColumnEntity columnEntity) {
        if (StringUtils.isEmpty((Object)columnEntity.getId()) || ((Query)DefaultDSLQueryService.createQuery((QueryByEntityDao)this.formColumnDao).where("id", columnEntity.getId())).total() == 0) {
            if (StringUtils.isEmpty((Object)columnEntity.getId())) {
                columnEntity.setId(this.getIDGenerator().generate());
            }
            this.tryValidate(columnEntity, new Class[]{CreateGroup.class});
            this.formColumnDao.insert(columnEntity);
        } else {
            this.tryValidate(columnEntity, new Class[]{UpdateGroup.class});
            ((Update)DefaultDSLUpdateService.createUpdate((UpdateByEntityDao)this.formColumnDao, (Object)columnEntity).where("id", columnEntity.getId())).exec();
        }
        return (String)columnEntity.getId();
    }

    @Caching(evict={@CacheEvict(key="'form-columns:'+#columnEntity.formId"), @CacheEvict(key="'form_id:'+#columnEntity.formId")})
    public String saveOrUpdateColumn(DynamicFormColumnEntity columnEntity) {
        String id = this.saveOrUpdate0(columnEntity);
        this.getDao().incrementVersion(columnEntity.getFormId());
        return id;
    }

    @CacheEvict(allEntries=true)
    public List<String> saveOrUpdateColumn(List<DynamicFormColumnEntity> columnEntities) {
        HashSet formId = new HashSet();
        List<String> columnIds = columnEntities.stream().peek(columnEntity -> formId.add(columnEntity.getFormId())).map(this::saveOrUpdateColumn).collect(Collectors.toList());
        formId.forEach(this.getDao()::incrementVersion);
        return columnIds;
    }

    @Caching(evict={@CacheEvict(key="'form-columns:'+#result"), @CacheEvict(key="'form_id:'+#result")})
    public String saveOrUpdate(DynamicFormColumnBindEntity bindEntity) {
        DynamicFormEntity formEntity = bindEntity.getForm();
        List columnEntities = bindEntity.getColumns();
        this.saveOrUpdate((GenericEntity)formEntity);
        columnEntities.stream().peek(column -> column.setFormId((String)formEntity.getId())).forEach(this::saveOrUpdate0);
        return (String)formEntity.getId();
    }

    @Caching(evict={@CacheEvict(key="'form-columns:'+#formId"), @CacheEvict(key="'form_id:'+#formId")})
    public DynamicFormColumnEntity deleteColumn(String formId) {
        DynamicFormColumnEntity oldColumn = (DynamicFormColumnEntity)((Query)DefaultDSLQueryService.createQuery((QueryByEntityDao)this.formColumnDao).where("id", (Object)formId)).single();
        SimpleDynamicFormService.assertNotNull((Object)oldColumn);
        ((Delete)DefaultDSLDeleteService.createDelete((DeleteByEntityDao)this.formColumnDao).where("id", (Object)formId)).exec();
        return oldColumn;
    }

    @Caching(evict={@CacheEvict(key="'form-columns:'+#id"), @CacheEvict(key="'form_id:'+#id")})
    public DynamicFormEntity deleteByPk(String id) {
        Objects.requireNonNull(id, "id can not be null");
        ((Delete)DefaultDSLDeleteService.createDelete((DeleteByEntityDao)this.formColumnDao).where("formId", (Object)id)).exec();
        return (DynamicFormEntity)super.deleteByPk((Object)id);
    }

    @CacheEvict(allEntries=true)
    public List<DynamicFormColumnEntity> deleteColumn(List<String> ids) {
        Objects.requireNonNull(ids);
        if (ids.isEmpty()) {
            return new ArrayList<DynamicFormColumnEntity>();
        }
        List oldColumns = ((Query)((Query)DefaultDSLQueryService.createQuery((QueryByEntityDao)this.formColumnDao).where()).in("id", ids)).listNoPaging();
        ((Delete)((Delete)DefaultDSLDeleteService.createDelete((DeleteByEntityDao)this.formColumnDao).where()).in("id", ids)).exec();
        return oldColumns;
    }

    public List<DynamicFormColumnEntity> selectColumnsByFormId(String formId) {
        Objects.requireNonNull(formId);
        return ((Query)DefaultDSLQueryService.createQuery((QueryByEntityDao)this.formColumnDao).where("formId", (Object)formId)).orderByAsc("sortIndex").listNoPaging();
    }

    @Cacheable(value={"dyn-form-deploy"}, key="'form-deploy:'+#formId+':'+#version")
    public DynamicFormColumnBindEntity selectDeployed(String formId, int version) {
        DynamicFormDeployLogEntity entity = this.dynamicFormDeployLogService.selectDeployed(formId, (long)version);
        if (entity == null) {
            return null;
        }
        return (DynamicFormColumnBindEntity)JSON.parseObject((String)entity.getMetaData(), DynamicFormColumnBindEntity.class);
    }

    @Cacheable(value={"dyn-form-deploy"}, key="'form-deploy-version:'+#formId")
    public long selectDeployedVersion(String formId) {
        DynamicFormColumnBindEntity entity = this.selectLatestDeployed(formId);
        if (null != entity) {
            return entity.getForm().getVersion();
        }
        return 0L;
    }

    @Cacheable(value={"dyn-form-deploy"}, key="'form-deploy:'+#formId+':latest'")
    public DynamicFormColumnBindEntity selectLatestDeployed(String formId) {
        DynamicFormDeployLogEntity entity = this.dynamicFormDeployLogService.selectLastDeployed(formId);
        if (entity == null) {
            return null;
        }
        return (DynamicFormColumnBindEntity)JSON.parseObject((String)entity.getMetaData(), DynamicFormColumnBindEntity.class);
    }

    public DynamicFormColumnBindEntity selectEditing(String formId) {
        Objects.requireNonNull(formId);
        return new DynamicFormColumnBindEntity(this.selectByPk(formId), this.selectColumnsByFormId(formId));
    }

    @Caching(evict={@CacheEvict(value={"dyn-form-deploy"}, key="'form-deploy-version:'+#formId"), @CacheEvict(value={"dyn-form-deploy"}, key="'form-deploy:'+#formId+':latest'"), @CacheEvict(value={"dyn-form"}, allEntries=true)})
    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void deploy(String formId) {
        DynamicFormEntity formEntity = this.selectByPk(formId);
        SimpleDynamicFormService.assertNotNull((Object)formEntity);
        if (Boolean.TRUE.equals(formEntity.getDeployed())) {
            this.dynamicFormDeployLogService.cancelDeployed(formId);
        }
        List<DynamicFormColumnEntity> columns = this.selectColumnsByFormId(formId);
        this.deploy(formEntity, columns, true);
        ((Update)this.createUpdate().set("deployed", (Object)true).where("id", (Object)formId)).exec();
        try {
            this.dynamicFormDeployLogService.insert((Object)this.createDeployLog(formEntity, columns));
            this.eventPublisher.publishEvent((Object)new FormDeployEvent(formId));
        }
        catch (Exception e) {
            this.unDeploy(formId);
            throw e;
        }
    }

    public void deploy(DynamicFormEntity form, List<DynamicFormColumnEntity> columns, boolean updateMeta) {
        RDBDatabase database = StringUtils.isEmpty((Object)form.getDataSourceId()) ? this.databaseRepository.getDefaultDatabase(form.getDatabaseName()) : this.databaseRepository.getDatabase(form.getDataSourceId(), form.getDatabaseName());
        this.initDatabase(database);
        RDBTableMetaData metaData = this.buildTable(database, form, columns);
        try {
            if (!database.getMeta().getParser().tableExists(metaData.getName())) {
                database.createTable(metaData);
            } else if (!updateMeta) {
                database.reloadTable(metaData);
            } else {
                database.alterTable(metaData);
            }
        }
        catch (SQLException e) {
            throw new DynamicFormException("\u90e8\u7f72\u5931\u8d25:" + e.getMessage(), e);
        }
    }

    protected Set<Correlation> buildCorrelations(String correlations) {
        if (StringUtils.isEmpty((Object)correlations)) {
            return new LinkedHashSet<Correlation>();
        }
        JSONArray correlationsConfig = JSON.parseArray((String)correlations);
        LinkedHashSet<Correlation> correlations1 = new LinkedHashSet<Correlation>();
        for (int i = 0; i < correlationsConfig.size(); ++i) {
            JSONObject single = correlationsConfig.getJSONObject(i);
            String target = single.getString("target");
            String alias = single.getString("alias");
            String condition = single.getString("condition");
            Objects.requireNonNull(target);
            Objects.requireNonNull(condition);
            Correlation correlation = new Correlation(target, alias, condition);
            correlation.setJoin(Correlation.JOIN.valueOf((String)String.valueOf(single.getOrDefault((Object)"join", (Object)"LEFT")).toUpperCase()));
            JSONObject properties = single.getJSONObject("properties");
            if (properties != null) {
                properties.forEach((arg_0, arg_1) -> ((Correlation)correlation).setProperty(arg_0, arg_1));
            }
            correlations1.add(correlation);
        }
        return correlations1;
    }

    protected Map<String, Trigger> buildTrigger(String config) {
        if (StringUtils.isEmpty((Object)config)) {
            return new HashMap<String, Trigger>();
        }
        JSONArray triggerConfig = JSON.parseArray((String)config);
        HashMap<String, Trigger> triggers = new HashMap<String, Trigger>();
        for (int i = 0; i < triggerConfig.size(); ++i) {
            JSONObject single = triggerConfig.getJSONObject(i);
            String trigger = single.getString("trigger");
            String language = single.getString("language");
            String script = single.getString("script");
            String scriptId = DigestUtils.md5Hex((String)script);
            try {
                DynamicScriptEngine engine = DynamicScriptEngineFactory.getEngine((String)language);
                if (engine == null) {
                    throw new UnsupportedOperationException("not support script language : " + language);
                }
                if (!engine.compiled(scriptId)) {
                    engine.compile(scriptId, script);
                }
                ScriptTraggerSupport singleTrigger = new ScriptTraggerSupport(engine, scriptId);
                triggers.put(trigger, (Trigger)singleTrigger);
                continue;
            }
            catch (Exception e) {
                throw new BusinessException("compile script error :" + e.getMessage(), (Throwable)e);
            }
        }
        return triggers;
    }

    protected RDBTableMetaData buildTable(RDBDatabase database, DynamicFormEntity form, List<DynamicFormColumnEntity> columns) {
        RDBTableMetaData metaData = new RDBTableMetaData();
        metaData.setComment(form.getDescribe());
        metaData.setName(form.getDatabaseTableName());
        if (null != form.getProperties()) {
            metaData.setProperties(form.getProperties());
        }
        metaData.setProperty("version", (Object)form.getVersion());
        metaData.setProperty("formId", form.getId());
        metaData.setAlias(form.getAlias());
        metaData.setCorrelations(this.buildCorrelations(form.getCorrelations()));
        metaData.setDatabaseMetaData(database.getMeta());
        this.buildTrigger(form.getTriggers()).forEach((arg_0, arg_1) -> ((RDBTableMetaData)metaData).on(arg_0, arg_1));
        columns.forEach(column -> {
            RDBColumnMetaData columnMeta = new RDBColumnMetaData();
            columnMeta.setName(column.getColumnName());
            columnMeta.setAlias(column.getAlias());
            columnMeta.setComment(column.getDescribe());
            columnMeta.setLength(column.getLength() == null ? 0 : column.getLength());
            columnMeta.setPrecision(column.getPrecision() == null ? 0 : column.getPrecision());
            columnMeta.setScale(column.getScale() == null ? 0 : column.getScale());
            columnMeta.setJdbcType(JDBCType.valueOf(column.getJdbcType()));
            columnMeta.setJavaType(this.getJavaType(column.getJavaType()));
            columnMeta.setProperties(column.getProperties() == null ? new HashMap() : column.getProperties());
            if (!CollectionUtils.isEmpty((Collection)column.getValidator())) {
                columnMeta.setValidator(new HashSet(column.getValidator()));
            }
            if (StringUtils.isEmpty((Object)column.getDataType())) {
                Dialect dialect = database.getMeta().getDialect();
                columnMeta.setDataType(dialect.buildDataType(columnMeta));
            } else {
                columnMeta.setDataType(column.getDataType());
            }
            columnMeta.setValueConverter(this.initColumnValueConvert(columnMeta.getJdbcType(), columnMeta.getJavaType()));
            if (this.optionalConvertBuilder != null && null != column.getDictConfig()) {
                try {
                    DictConfig config = (DictConfig)JSON.parseObject((String)column.getDictConfig(), DictConfig.class);
                    config.setColumn(columnMeta);
                    columnMeta.setOptionConverter(this.optionalConvertBuilder.build(config));
                    ValueConverter converter = this.optionalConvertBuilder.buildValueConverter(config);
                    if (null != converter) {
                        columnMeta.setValueConverter(converter);
                    }
                }
                catch (Exception e) {
                    this.logger.warn("\u521b\u5efa\u5b57\u5178\u8f6c\u6362\u5668\u5931\u8d25", (Throwable)e);
                }
            }
            this.customColumnSetting(database, form, metaData, (DynamicFormColumnEntity)column, columnMeta);
            metaData.addColumn(columnMeta);
        });
        if (this.objectWrapperFactory != null) {
            metaData.setObjectWrapper(this.objectWrapperFactory.createObjectWrapper((TableMetaData)metaData));
        }
        metaData.setValidator(this.validatorFactory.createValidator((TableMetaData)metaData));
        this.customTableSetting(database, form, metaData);
        if (metaData.getColumns().stream().noneMatch(RDBColumnMetaData::isPrimaryKey) && metaData.findColumn("id") == null) {
            RDBColumnMetaData primaryKey = this.createPrimaryKeyColumn();
            Dialect dialect = database.getMeta().getDialect();
            primaryKey.setDataType(dialect.buildDataType(primaryKey));
            metaData.addColumn(primaryKey);
        }
        return metaData;
    }

    protected RDBColumnMetaData createPrimaryKeyColumn() {
        RDBColumnMetaData id = new RDBColumnMetaData();
        id.setName("id");
        id.setJdbcType(JDBCType.VARCHAR);
        id.setJavaType(String.class);
        id.setLength(32);
        id.setDefaultValue(() -> ((IDGenerator)IDGenerator.MD5).generate());
        id.setComment("\u4e3b\u952e");
        id.setPrimaryKey(true);
        id.setNotNull(true);
        id.setProperty("read-only", (Object)true);
        return id;
    }

    protected void customTableSetting(final RDBDatabase database, final DynamicFormEntity formEntity, final RDBTableMetaData table) {
        TableInitializeContext context = new TableInitializeContext(){

            public RDBDatabase getDatabase() {
                return database;
            }

            public DynamicFormEntity getFormEntity() {
                return formEntity;
            }

            public RDBTableMetaData getTable() {
                return table;
            }
        };
        if (!CollectionUtils.isEmpty(this.initializeCustomizers)) {
            this.initializeCustomizers.forEach(customizer -> customizer.customTableSetting(context));
        }
    }

    protected void customColumnSetting(final RDBDatabase database, final DynamicFormEntity formEntity, final RDBTableMetaData table, final DynamicFormColumnEntity columnEntity, final RDBColumnMetaData column) {
        ColumnInitializeContext context = new ColumnInitializeContext(){

            public DynamicFormColumnEntity getColumnEntity() {
                return columnEntity;
            }

            public RDBColumnMetaData getColumn() {
                return column;
            }

            public RDBDatabase getDatabase() {
                return database;
            }

            public DynamicFormEntity getFormEntity() {
                return formEntity;
            }

            public RDBTableMetaData getTable() {
                return table;
            }
        };
        if (!CollectionUtils.isEmpty(this.initializeCustomizers)) {
            this.initializeCustomizers.forEach(customer -> customer.customTableColumnSetting(context));
        }
    }

    protected ValueConverter initColumnValueConvert(JDBCType jdbcType, Class javaType) {
        boolean isBasicClass;
        boolean bl = isBasicClass = !classMapping.values().contains(javaType) || javaType != Map.class || javaType != List.class;
        if (javaType.isEnum() && EnumDict.class.isAssignableFrom(javaType)) {
            return new EnumDictValueConverter(() -> Arrays.asList(javaType.getEnumConstants()));
        }
        switch (jdbcType) {
            case BLOB: {
                if (!isBasicClass) {
                    return new JSONValueConverter(javaType, (ValueConverter)new BlobValueConverter());
                }
                return new BlobValueConverter();
            }
            case CLOB: {
                if (!isBasicClass) {
                    return new JSONValueConverter(javaType, (ValueConverter)new ClobValueConverter());
                }
                return new ClobValueConverter();
            }
            case NUMERIC: 
            case BIGINT: 
            case INTEGER: 
            case SMALLINT: 
            case TINYINT: {
                return new NumberValueConverter(javaType);
            }
            case DATE: 
            case TIMESTAMP: 
            case TIME: {
                return new DateTimeConverter("yyyy-MM-dd HH:mm:ss", javaType);
            }
        }
        if (!isBasicClass) {
            return new JSONValueConverter(javaType, (ValueConverter)new DefaultValueConverter());
        }
        if (javaType == String.class && (jdbcType == JDBCType.VARCHAR || jdbcType == JDBCType.NVARCHAR)) {
            return new DefaultValueConverter(){

                public Object getData(Object value) {
                    if (value instanceof Number) {
                        return value.toString();
                    }
                    return super.getData(value);
                }
            };
        }
        return new DefaultValueConverter();
    }

    private Class getJavaType(String type) {
        if (StringUtils.isEmpty((Object)type)) {
            return String.class;
        }
        Class clazz = classMapping.get(type);
        if (clazz == null) {
            try {
                clazz = ClassUtils.forName((String)type, null);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return clazz;
    }

    static {
        classMapping.put("string", String.class);
        classMapping.put("String", String.class);
        classMapping.put("int", Integer.class);
        classMapping.put("Integer", Integer.class);
        classMapping.put("byte", Byte.class);
        classMapping.put("Byte", Byte.class);
        classMapping.put("byte[]", Byte[].class);
        classMapping.put("Byte[]", Byte[].class);
        classMapping.put("short", Short.class);
        classMapping.put("Short", Short.class);
        classMapping.put("boolean", Boolean.class);
        classMapping.put("Boolean", Boolean.class);
        classMapping.put("double", Double.class);
        classMapping.put("Double", Double.class);
        classMapping.put("float", Float.class);
        classMapping.put("Float", Float.class);
        classMapping.put("long", Long.class);
        classMapping.put("Long", Long.class);
        classMapping.put("char", Character.class);
        classMapping.put("Char", Character.class);
        classMapping.put("char[]", Character[].class);
        classMapping.put("Char[]", Character[].class);
        classMapping.put("Character", Character.class);
        classMapping.put("BigDecimal", BigDecimal.class);
        classMapping.put("BigInteger", BigInteger.class);
        classMapping.put("map", Map.class);
        classMapping.put("Map", Map.class);
        classMapping.put("list", List.class);
        classMapping.put("List", List.class);
        classMapping.put("date", Date.class);
        classMapping.put("Date", Date.class);
    }
}

