/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.form.simple;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hswebframework.ezorm.core.Delete;
import org.hswebframework.ezorm.core.Insert;
import org.hswebframework.ezorm.core.Query;
import org.hswebframework.ezorm.core.Update;
import org.hswebframework.ezorm.core.meta.AbstractColumnMetaData;
import org.hswebframework.ezorm.core.param.Param;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.rdb.RDBDatabase;
import org.hswebframework.ezorm.rdb.RDBQuery;
import org.hswebframework.ezorm.rdb.RDBTable;
import org.hswebframework.ezorm.rdb.meta.RDBColumnMetaData;
import org.hswebframework.ezorm.rdb.meta.RDBTableMetaData;
import org.hswebframework.web.BusinessException;
import org.hswebframework.web.NotFoundException;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.commons.entity.PagerResult;
import org.hswebframework.web.commons.entity.param.DeleteParamEntity;
import org.hswebframework.web.commons.entity.param.QueryParamEntity;
import org.hswebframework.web.commons.entity.param.UpdateParamEntity;
import org.hswebframework.web.entity.form.DynamicFormEntity;
import org.hswebframework.web.service.form.DatabaseRepository;
import org.hswebframework.web.service.form.DynamicFormOperationService;
import org.hswebframework.web.service.form.DynamicFormService;
import org.hswebframework.web.service.form.events.FormDataInsertBeforeEvent;
import org.hswebframework.web.service.form.events.FormDataUpdateBeforeEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service(value="dynamicFormOperationService")
@Transactional(rollbackFor={Throwable.class})
public class SimpleDynamicFormOperationService
implements DynamicFormOperationService {
    private static final Logger log = LoggerFactory.getLogger(SimpleDynamicFormOperationService.class);
    @Autowired
    private DynamicFormService dynamicFormService;
    @Autowired
    private DatabaseRepository databaseRepository;
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    protected <T> RDBTable<T> getTable(String formId) {
        DynamicFormEntity form = (DynamicFormEntity)this.dynamicFormService.selectByPk((Object)formId);
        if (null == form || Boolean.FALSE.equals(form.getDeployed())) {
            throw new NotFoundException("\u8868\u5355\u4e0d\u5b58\u5728");
        }
        RDBDatabase database = StringUtils.isEmpty((Object)form.getDataSourceId()) ? this.databaseRepository.getDefaultDatabase(form.getDatabaseName()) : this.databaseRepository.getDatabase(form.getDataSourceId(), form.getDatabaseName());
        return database.getTable(form.getDatabaseTableName());
    }

    protected RDBDatabase getDatabase(String formId) {
        DynamicFormEntity form = (DynamicFormEntity)this.dynamicFormService.selectByPk((Object)formId);
        if (null == form || Boolean.FALSE.equals(form.getDeployed())) {
            throw new NotFoundException("\u8868\u5355\u4e0d\u5b58\u5728");
        }
        return StringUtils.isEmpty((Object)form.getDataSourceId()) ? this.databaseRepository.getDefaultDatabase(form.getDatabaseName()) : this.databaseRepository.getDatabase(form.getDataSourceId(), form.getDatabaseName());
    }

    @Transactional(readOnly=true)
    public <T> PagerResult<T> selectPager(String formId, QueryParamEntity paramEntity) {
        RDBTable<T> table = this.getTable(formId);
        RDBQuery query = table.createQuery();
        int total = query.setParam((QueryParam)paramEntity).total();
        if (total == 0) {
            return PagerResult.empty();
        }
        paramEntity.rePaging(total);
        List list = query.setParam((QueryParam)paramEntity).list(paramEntity.getPageIndex(), paramEntity.getPageSize());
        return PagerResult.of((int)total, (List)list, (QueryParamEntity)paramEntity);
    }

    @Transactional(readOnly=true)
    public <T> List<T> select(String formId, QueryParamEntity paramEntity) {
        RDBTable<T> table = this.getTable(formId);
        RDBQuery query = table.createQuery();
        return query.setParam((QueryParam)paramEntity).list();
    }

    @Transactional(readOnly=true)
    public <T> T selectSingle(String formId, QueryParamEntity paramEntity) {
        RDBTable<T> table = this.getTable(formId);
        RDBQuery query = table.createQuery();
        return (T)query.setParam((QueryParam)paramEntity).single();
    }

    @Transactional(readOnly=true)
    public int count(String formId, QueryParamEntity paramEntity) {
        RDBTable table = this.getTable(formId);
        RDBQuery query = table.createQuery();
        return query.setParam((QueryParam)paramEntity).total();
    }

    public <T> int update(String formId, UpdateParamEntity<T> paramEntity) {
        if (Objects.requireNonNull(paramEntity).getTerms().isEmpty()) {
            throw new UnsupportedOperationException("\u4e0d\u80fd\u6267\u884c\u65e0\u6761\u4ef6\u7684\u66f4\u65b0\u64cd\u4f5c");
        }
        RDBTable<T> table = this.getTable(formId);
        Update update = table.createUpdate();
        return update.setParam(paramEntity).exec();
    }

    public <T> T insert(String formId, T entity) {
        RDBTable<T> table = this.getTable(formId);
        Insert insert = table.createInsert();
        this.eventPublisher.publishEvent((Object)new FormDataInsertBeforeEvent(formId, table, entity));
        insert.value(entity).exec();
        return entity;
    }

    private String getIdProperty(RDBTableMetaData tableMetaData) {
        return tableMetaData.getColumns().stream().filter(RDBColumnMetaData::isPrimaryKey).findFirst().map(AbstractColumnMetaData::getAlias).orElseThrow(() -> new BusinessException("\u8868[" + tableMetaData.getName() + "]\u672a\u8bbe\u7f6e\u4e3b\u952e\u5b57\u6bb5"));
    }

    protected <T> Object getExistingDataId(String formId, T data) {
        RDBTable<T> table = this.getTable(formId);
        String triggerName = "check-data-existing";
        boolean useTrigger = table.getMeta().triggerIsSupport(triggerName);
        String idProperty = this.getIdProperty(table.getMeta());
        if (useTrigger) {
            HashMap<String, Object> triggerContext = new HashMap<String, Object>();
            triggerContext.put("table", table);
            triggerContext.put("database", this.getDatabase(formId));
            triggerContext.put("data", data);
            Object result = table.getMeta().on(triggerName, triggerContext);
            if (result instanceof String) {
                return result;
            }
            if (result instanceof Map) {
                Object id = ((Map)result).get(idProperty);
                if (id == null) {
                    log.error("table:[{}]\u89e6\u53d1\u5668\u8fd4\u56de\u4e86\u6570\u636e:[{}],\u4f46\u662f\u4e0d\u5305\u542b\u4e3b\u952e\u5b57\u6bb5:[{}]", new Object[]{table.getMeta().getName(), data, idProperty});
                    throw new BusinessException("\u6570\u636e\u9519\u8bef,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                }
                return id;
            }
        } else {
            Map mapData = (Map)FastBeanCopier.copy(data, new HashMap(), (String[])new String[0]);
            Object id = mapData.get(idProperty);
            if (null == id) {
                return null;
            }
            T existing = this.selectSingle(formId, (QueryParamEntity)QueryParamEntity.single((String)idProperty, id).includes(new String[]{idProperty}));
            if (null != existing) {
                mapData = (Map)FastBeanCopier.copy(data, new HashMap(), (String[])new String[0]);
                return mapData.get(idProperty);
            }
        }
        return null;
    }

    public <T> T saveOrUpdate(String formId, T data) {
        Objects.requireNonNull(formId, "\u8868\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        Object id = this.getExistingDataId(formId, data);
        if (null == id) {
            this.insert(formId, data);
        } else {
            this.updateById(formId, id, data);
        }
        return data;
    }

    public int delete(String formId, DeleteParamEntity paramEntity) {
        if (Objects.requireNonNull(paramEntity).getTerms().isEmpty()) {
            throw new UnsupportedOperationException("\u4e0d\u80fd\u6267\u884c\u65e0\u6761\u4ef6\u7684\u5220\u9664\u64cd\u4f5c");
        }
        RDBTable table = this.getTable(formId);
        Delete delete = table.createDelete();
        return delete.setParam((Param)paramEntity).exec();
    }

    public int deleteById(String formId, Object id) {
        Objects.requireNonNull(id, "\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        RDBTable table = this.getTable(formId);
        return ((Delete)table.createDelete().where(this.getIdProperty(table.getMeta()), id)).exec();
    }

    public <T> T selectById(String formId, Object id) {
        Objects.requireNonNull(id, "\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        RDBTable<T> table = this.getTable(formId);
        return (T)((Query)table.createQuery().where(this.getIdProperty(table.getMeta()), id)).single();
    }

    public <T> T updateById(String formId, Object id, T data) {
        Objects.requireNonNull(id, "\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        RDBTable<T> table = this.getTable(formId);
        this.eventPublisher.publishEvent((Object)new FormDataUpdateBeforeEvent(formId, table, data, id));
        ((Update)table.createUpdate().set(data).where(this.getIdProperty(table.getMeta()), id)).exec();
        return data;
    }
}

