/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.form.simple;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import org.hswebframework.ezorm.rdb.RDBDatabase;
import org.hswebframework.ezorm.rdb.executor.SqlExecutor;
import org.hswebframework.ezorm.rdb.meta.RDBDatabaseMetaData;
import org.hswebframework.ezorm.rdb.meta.parser.H2TableMetaParser;
import org.hswebframework.ezorm.rdb.meta.parser.MysqlTableMetaParser;
import org.hswebframework.ezorm.rdb.meta.parser.OracleTableMetaParser;
import org.hswebframework.ezorm.rdb.meta.parser.PGSqlTableMetaParser;
import org.hswebframework.ezorm.rdb.meta.parser.SqlServer2012TableMetaParser;
import org.hswebframework.ezorm.rdb.meta.parser.TableMetaParser;
import org.hswebframework.ezorm.rdb.render.dialect.AbstractRDBDatabaseMetaData;
import org.hswebframework.ezorm.rdb.render.dialect.H2RDBDatabaseMetaData;
import org.hswebframework.ezorm.rdb.render.dialect.MSSQLRDBDatabaseMetaData;
import org.hswebframework.ezorm.rdb.render.dialect.MysqlRDBDatabaseMetaData;
import org.hswebframework.ezorm.rdb.render.dialect.OracleRDBDatabaseMetaData;
import org.hswebframework.ezorm.rdb.render.dialect.PGRDBDatabaseMetaData;
import org.hswebframework.ezorm.rdb.simple.SimpleDatabase;
import org.hswebframework.web.datasource.DataSourceHolder;
import org.hswebframework.web.datasource.DatabaseType;
import org.hswebframework.web.datasource.DynamicDataSource;
import org.hswebframework.web.service.form.DatabaseRepository;
import org.hswebframework.web.service.form.events.DatabaseInitEvent;
import org.hswebframework.web.service.form.simple.cluster.ClusterDatabase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class SimpleDatabaseRepository
implements DatabaseRepository {
    private volatile RDBDatabase defaultDatabase = null;
    private SqlExecutor sqlExecutor = null;
    @Value(value="${hsweb.dynamic-form.cluster:false}")
    private boolean cluster = false;
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    private final Map<String, RDBDatabase> repository = new HashMap<String, RDBDatabase>();
    private final Map<DatabaseType, Supplier<AbstractRDBDatabaseMetaData>> databaseMetaSuppliers = new EnumMap<DatabaseType, Supplier<AbstractRDBDatabaseMetaData>>(DatabaseType.class);

    @Autowired
    public void setSqlExecutor(SqlExecutor sqlExecutor) {
        this.sqlExecutor = sqlExecutor;
    }

    @PostConstruct
    public void init() {
        Objects.requireNonNull(this.sqlExecutor);
        this.databaseMetaSuppliers.put(DatabaseType.oracle, () -> {
            OracleRDBDatabaseMetaData metaData = new OracleRDBDatabaseMetaData();
            metaData.setParser((TableMetaParser)new OracleTableMetaParser(this.sqlExecutor));
            return metaData;
        });
        this.databaseMetaSuppliers.put(DatabaseType.mysql, () -> {
            MysqlRDBDatabaseMetaData metaData = new MysqlRDBDatabaseMetaData();
            metaData.setParser((TableMetaParser)new MysqlTableMetaParser(this.sqlExecutor));
            return metaData;
        });
        this.databaseMetaSuppliers.put(DatabaseType.h2, () -> {
            H2RDBDatabaseMetaData metaData = new H2RDBDatabaseMetaData();
            metaData.setParser((TableMetaParser)new H2TableMetaParser(this.sqlExecutor));
            return metaData;
        });
        this.databaseMetaSuppliers.put(DatabaseType.jtds_sqlserver, () -> {
            MSSQLRDBDatabaseMetaData metaData = new MSSQLRDBDatabaseMetaData();
            metaData.setParser((TableMetaParser)new SqlServer2012TableMetaParser(this.sqlExecutor));
            return metaData;
        });
        this.databaseMetaSuppliers.put(DatabaseType.sqlserver, this.databaseMetaSuppliers.get(DatabaseType.jtds_sqlserver));
        this.databaseMetaSuppliers.put(DatabaseType.postgresql, () -> {
            PGRDBDatabaseMetaData metaData = new PGRDBDatabaseMetaData();
            metaData.setParser((TableMetaParser)new PGSqlTableMetaParser(this.sqlExecutor));
            return metaData;
        });
    }

    public RDBDatabase getDefaultDatabase(String databaseName) {
        return this.repository.computeIfAbsent("DEFAULT." + databaseName, id -> this.initDatabase(DataSourceHolder.defaultDatabaseType(), databaseName));
    }

    public RDBDatabase getDatabase(String datasourceId, String databaseName) {
        DynamicDataSource dynamicDataSource = DataSourceHolder.dataSource((String)datasourceId);
        return this.repository.computeIfAbsent(datasourceId + "." + databaseName, id -> this.initDatabase(dynamicDataSource.getType(), databaseName));
    }

    public RDBDatabase getCurrentDatabase() {
        return this.repository.computeIfAbsent(DataSourceHolder.switcher().currentDataSourceId(), id -> this.initDatabase(DataSourceHolder.currentDatabaseType(), null));
    }

    private RDBDatabase initDatabase(DatabaseType databaseType, String databaseName) {
        Supplier<AbstractRDBDatabaseMetaData> supplier = this.databaseMetaSuppliers.get(databaseType);
        Objects.requireNonNull(supplier, "database type" + databaseType + " is not support");
        AbstractRDBDatabaseMetaData metaData = supplier.get();
        metaData.setDatabaseName(databaseName);
        ClusterDatabase database = this.cluster ? new ClusterDatabase((RDBDatabaseMetaData)metaData, this.sqlExecutor) : new SimpleDatabase((RDBDatabaseMetaData)metaData, this.sqlExecutor);
        database.setAutoParse(true);
        this.eventPublisher.publishEvent((Object)new DatabaseInitEvent((RDBDatabase)database));
        return database;
    }
}

