/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dictionary.service;

import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.cache.ReactiveCacheManager;
import org.hswebframework.web.dict.DictDefine;
import org.hswebframework.web.dict.defaults.DefaultDictDefineRepository;
import org.hswebframework.web.dictionary.entity.DictionaryEntity;
import org.hswebframework.web.dictionary.event.ClearDictionaryCacheEvent;
import org.hswebframework.web.dictionary.service.DefaultDictionaryService;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CompositeDictDefineRepository
extends DefaultDictDefineRepository {
    private static final Logger log = LoggerFactory.getLogger(CompositeDictDefineRepository.class);
    @Autowired
    private DefaultDictionaryService dictionaryService;
    @Autowired
    private ReactiveCacheManager cacheManager;

    @EventListener
    public void handleClearCacheEvent(ClearDictionaryCacheEvent event) {
        if (StringUtils.isEmpty((Object)event.getDictionaryId())) {
            this.cacheManager.getCache("dic-define").clear().doOnSuccess(r -> log.info("clear all dic cache success")).subscribe();
        } else {
            this.cacheManager.getCache("dic-define").evict((Object)event.getDictionaryId()).doOnSuccess(r -> log.info("clear dict [{}] cache success", (Object)event.getDictionaryId())).subscribe();
        }
    }

    public Mono<DictDefine> getDefine(String id) {
        return super.getDefine(id).switchIfEmpty(Mono.defer(() -> this.cacheManager.getCache("dic-define").getMono((Object)id, () -> this.getFromDb(id))));
    }

    public Flux<DictDefine> getAllDefine() {
        Publisher[] publisherArray = new Publisher[2];
        publisherArray[0] = super.getAllDefine();
        publisherArray[1] = ((Flux)QueryParamEntity.newQuery().noPaging().execute(this.dictionaryService::findAllDetail)).map(DictionaryEntity::toDictDefine);
        return Flux.concat((Publisher[])publisherArray);
    }

    private Mono<DictDefine> getFromDb(String id) {
        return this.dictionaryService.findDetailById(id).filter(e -> Byte.valueOf((byte)1).equals(e.getStatus())).map(DictionaryEntity::toDictDefine);
    }
}

