/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.controller.dictionary;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.commons.entity.param.QueryParamEntity;
import org.hswebframework.web.controller.SimpleGenericEntityController;
import org.hswebframework.web.controller.message.ResponseMessage;
import org.hswebframework.web.dict.DictDefine;
import org.hswebframework.web.dict.DictDefineRepository;
import org.hswebframework.web.dict.EnumDict;
import org.hswebframework.web.dictionary.api.DictionaryService;
import org.hswebframework.web.dictionary.api.entity.DictionaryEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${hsweb.web.mappings.dictionary:dictionary}"})
@Authorize(permission={"dictionary"}, description={"\u6570\u636e\u5b57\u5178\u7ba1\u7406"})
@Api(value="\u6570\u636e\u5b57\u5178", tags={"\u6570\u636e\u5b57\u5178-\u5b57\u5178\u914d\u7f6e"})
public class DictionaryController
implements SimpleGenericEntityController<DictionaryEntity, String, QueryParamEntity> {
    @Autowired
    private DictionaryService dictionaryService;
    @Autowired
    private DictDefineRepository repository;

    public DictionaryService getService() {
        return this.dictionaryService;
    }

    @GetMapping(value={"/define/all"})
    @Authorize(merge=false)
    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u5168\u90e8\u5b57\u5178\u5b9a\u4e49\u4fe1\u606f")
    public ResponseMessage<List<DictDefine>> getAllDefineById() {
        return ResponseMessage.ok((Object)this.repository.getAllDefine());
    }

    @GetMapping(value={"/define/{id:.+}"})
    @Authorize(merge=false)
    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u5b57\u5178\u5b9a\u4e49\u4fe1\u606f")
    public ResponseMessage<DictDefine> getDefineById(@PathVariable String id) {
        return ResponseMessage.ok((Object)this.repository.getDefine(id));
    }

    @GetMapping(value={"/define/{id:.+}/items"})
    @Authorize(merge=false)
    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u5b57\u5178\u9009\u9879\u4fe1\u606f")
    public ResponseMessage<List<EnumDict<Object>>> getItemDefineById(@PathVariable String id) {
        return ResponseMessage.ok(Optional.ofNullable(this.repository.getDefine(id)).map(DictDefine::getItems).orElse(new ArrayList()));
    }
}

