/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dictionary.simple.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.hswebframework.web.RegexUtils;
import org.hswebframework.web.dictionary.simple.parser.DictParserFormat;
import org.hswebframework.web.dictionary.simple.parser.DictParserFormatter;
import org.hswebframework.web.dictionary.simple.parser.FormatterResult;

public class SimpleDictParserFormatter
implements DictParserFormatter {
    public boolean smartParse = true;
    public int smartLevel = 3;

    public void setSmartParse(boolean smartParse) {
        this.smartParse = smartParse;
    }

    public boolean needParse(String value, DictParserFormat format) {
        return value.contains(format.getSplitter()) || value.contains(format.getChildSplitter()) || value.contains(format.getChildStartChar());
    }

    private <T> FormatterResult<T> createResult(T v, String pattern) {
        return new FormatterResult<T>(v, pattern);
    }

    @Override
    public <T> List<FormatterResult<T>> format(DictParserFormat format, Object value, BiFunction<String, String, T> mapping) {
        if (value == null) {
            return new ArrayList<FormatterResult<T>>();
        }
        String stringValue = String.valueOf(value);
        if (!this.needParse(stringValue, format)) {
            return Collections.singletonList(this.createResult(mapping.apply(stringValue, stringValue), stringValue));
        }
        String splitter = "[" + RegexUtils.escape((String)(format.getSplitter() + " " + format.getChildStartChar() + " " + format.getChildSplitter() + " " + format.getChildEndChar())) + "]";
        return Arrays.stream(stringValue.split(splitter)).map(val -> {
            Object v = mapping.apply((String)val, (String)val);
            if (v == null && this.smartParse) {
                StringBuilder tmp = new StringBuilder();
                char[] arr = val.toCharArray();
                for (int i = 0; i < arr.length; ++i) {
                    tmp.append(arr[i]);
                    if (i >= this.smartLevel && null != (v = mapping.apply(tmp.toString(), (String)val))) break;
                }
            }
            return this.createResult((Object)v, (String)val);
        }).collect(Collectors.toList());
    }
}

