/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dictionary.simple;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.hswebframework.web.commons.entity.DataStatus;
import org.hswebframework.web.dict.DictDefine;
import org.hswebframework.web.dict.defaults.DefaultDictDefine;
import org.hswebframework.web.dict.defaults.DefaultDictDefineRepository;
import org.hswebframework.web.dictionary.api.DictionaryItemService;
import org.hswebframework.web.dictionary.api.DictionaryService;
import org.hswebframework.web.dictionary.api.entity.DictionaryEntity;
import org.hswebframework.web.dictionary.api.events.ClearDictionaryCacheEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.event.TransactionalEventListener;

@Service
@CacheConfig(cacheNames={"dictionary"})
public class BoostDictDefineRepository
extends DefaultDictDefineRepository {
    private static final Logger log = LoggerFactory.getLogger(BoostDictDefineRepository.class);
    @Autowired
    private DictionaryService dictionaryService;
    @Autowired
    private DictionaryItemService itemService;

    @TransactionalEventListener
    @CacheEvict(key="'dictDefineById:'+#event.dictionaryId", condition="#event!=null")
    public void clearCache(ClearDictionaryCacheEvent event) {
        log.info("clear dictionary define cache:{}", (Object)event.getDictionaryId());
    }

    @Cacheable(key="'dictDefineById:'+#id")
    public DictDefine getDefine(String id) {
        DictionaryEntity entity = (DictionaryEntity)this.dictionaryService.selectByPk((Object)id);
        if (entity == null) {
            return super.getDefine(id);
        }
        List items = this.itemService.selectByDictId(id).stream().filter(e -> DataStatus.STATUS_ENABLED.equals(e.getStatus())).collect(Collectors.toList());
        return DefaultDictDefine.builder().id(id).comments(entity.getDescribe()).items(items).build();
    }

    public List<DictDefine> getAllDefine() {
        List<DictDefine> all = this.dictionaryService.select().stream().map(dict -> DefaultDictDefine.builder().id((String)dict.getId()).comments(dict.getDescribe()).items(new ArrayList(dict.getItems())).build()).collect(Collectors.toList());
        all.addAll(super.getAllDefine());
        return all;
    }
}

