/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dictionary.simple.parser;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.hswebframework.web.ExpressionUtils;
import org.hswebframework.web.dictionary.api.entity.DictionaryEntity;
import org.hswebframework.web.dictionary.api.entity.DictionaryItemEntity;
import org.hswebframework.web.dictionary.api.parser.SingleDictParser;
import org.hswebframework.web.dictionary.simple.parser.DictParserFormat;
import org.hswebframework.web.dictionary.simple.parser.DictParserFormatter;
import org.hswebframework.web.dictionary.simple.parser.FormatterResult;
import org.hswebframework.web.dictionary.simple.parser.SimpleDictParserFormatter;

public class SimpleSingleDictParser
implements SingleDictParser {
    private Map<String, DictMapping> mapping = new HashMap<String, DictMapping>();
    private DictParserFormat sourceFormat = new DictParserFormat();
    private DictParserFormat targetFormat = new DictParserFormat();
    private DictParserFormatter formatter = new SimpleDictParserFormatter();

    public void setDict(DictionaryEntity dict, Function<DictionaryItemEntity, String> keyGetter, Function<DictionaryItemEntity, String> valueGetter, Function<DictionaryItemEntity, String> expressionGetter) {
        dict.getItems().forEach(item -> this.addMapping((DictionaryItemEntity)item, keyGetter, valueGetter, expressionGetter));
    }

    public void setSourceFormat(DictParserFormat sourceFormat) {
        this.sourceFormat = sourceFormat;
    }

    public void setTargetFormat(DictParserFormat targetFormat) {
        this.targetFormat = targetFormat;
    }

    public DictParserFormat getTargetFormat() {
        return this.targetFormat;
    }

    public DictParserFormat getSourceFormat() {
        return this.sourceFormat;
    }

    private DictMapping addMapping(DictionaryItemEntity item, Function<DictionaryItemEntity, String> keyGetter, Function<DictionaryItemEntity, String> valueGetter, Function<DictionaryItemEntity, String> expressionGetter) {
        DictMapping dictMapping = new DictMapping();
        dictMapping.setValue(valueGetter.apply(item));
        dictMapping.setExpression(expressionGetter.apply(item));
        if (item.getChildren() != null) {
            dictMapping.setChildren(item.getChildren().stream().map(DictionaryItemEntity.class::cast).map(i -> this.addMapping((DictionaryItemEntity)i, keyGetter, valueGetter, expressionGetter)).collect(Collectors.toList()));
        }
        String key = keyGetter.apply(item);
        dictMapping.setKey(key);
        this.mapping.put(key, dictMapping);
        return dictMapping;
    }

    public Optional<String> parse(String value, Object context) {
        if (value == null) {
            return Optional.empty();
        }
        StringJoiner joiner = this.targetFormat.createJoiner();
        List dictMappings = this.formatter.format(this.sourceFormat, value, (key, pattern) -> {
            DictMapping dictMapping = this.mapping.get(key);
            if (dictMapping == null) {
                return null;
            }
            dictMapping = dictMapping.clone();
            dictMapping.setDefaultVar(Collections.singletonMap("pattern", pattern));
            return dictMapping;
        }).stream().filter(Objects::nonNull).map(FormatterResult::getResult).collect(Collectors.toList());
        HashSet notAppendList = new HashSet();
        List<String> mappingResult = dictMappings.stream().filter(Objects::nonNull).peek(dictMapping -> dictMapping.filterChildren(mapping -> {
            String strVal = mapping.getValue();
            notAppendList.add(strVal);
            int index = dictMappings.indexOf(this.mappingOfValue(strVal));
            DictMapping tmp = null;
            if (-1 != index) {
                tmp = (DictMapping)dictMappings.get(index);
            }
            if (null != tmp) {
                mapping.setDefaultVar(tmp.getDefaultVar());
            }
            return null != tmp;
        })).filter(mapping -> !notAppendList.contains(mapping.getValue())).map(dict -> dict.toString(context)).collect(Collectors.toList());
        mappingResult.forEach(joiner::add);
        return Optional.ofNullable(joiner.toString());
    }

    public void setMapping(Map<String, DictMapping> mapping) {
        this.mapping = mapping;
    }

    DictMapping mappingOfValue(String value) {
        DictMapping mapping = new DictMapping();
        mapping.setValue(value);
        return mapping;
    }

    protected class DictMapping
    implements Serializable {
        private String key;
        private String value;
        private String expression;
        private String expressionLanguage = "spel";
        private List<DictMapping> children;
        private Map<String, Object> defaultVar;

        protected DictMapping() {
        }

        public void setDefaultVar(Map<String, Object> defaultVar) {
            this.defaultVar = defaultVar;
        }

        public Map<String, Object> getDefaultVar() {
            return this.defaultVar;
        }

        public int hashCode() {
            if (this.value == null) {
                return 0;
            }
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return obj == this || this.hashCode() == obj.hashCode();
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public List<DictMapping> getChildren() {
            return this.children;
        }

        public String getExpression() {
            return this.expression;
        }

        public void setExpression(String expression) {
            this.expression = expression;
        }

        public void setExpressionLanguage(String expressionLanguage) {
            this.expressionLanguage = expressionLanguage;
        }

        public String getExpressionLanguage() {
            if (this.expressionLanguage == null) {
                this.expressionLanguage = "spel";
            }
            return this.expressionLanguage;
        }

        public void setChildren(List<DictMapping> children) {
            this.children = children;
        }

        public String toString(Function<DictMapping, String> getter) {
            StringBuilder stringBuilder = new StringBuilder(getter.apply(this));
            if (this.children != null) {
                String childrenString = String.join((CharSequence)SimpleSingleDictParser.this.targetFormat.getChildSplitter(), this.children.stream().map(mapping -> mapping.toString(getter)).collect(Collectors.toList()));
                if (childrenString.isEmpty()) {
                    return stringBuilder.toString();
                }
                stringBuilder.append(SimpleSingleDictParser.this.targetFormat.getChildStartChar()).append(childrenString).append(SimpleSingleDictParser.this.targetFormat.getChildEndChar());
            }
            return stringBuilder.toString();
        }

        public String toString(Object context) {
            Function<DictMapping, String> textGetter = context == null ? DictMapping::getValue : dictMapping -> {
                if (dictMapping.getExpression() == null || dictMapping.getExpression().isEmpty()) {
                    return dictMapping.getValue();
                }
                HashMap<String, Object> var = new HashMap<String, Object>();
                if (dictMapping.getDefaultVar() != null) {
                    var.putAll(dictMapping.getDefaultVar());
                }
                var.put("value", dictMapping.getValue());
                var.put("key", dictMapping.getKey());
                var.put("context", context);
                var.put("children", dictMapping.getChildren());
                try {
                    return ExpressionUtils.analytical((String)dictMapping.getExpression(), var, (String)dictMapping.getExpressionLanguage());
                }
                catch (Exception e) {
                    throw new RuntimeException("analytical " + dictMapping.getExpressionLanguage() + " expression :" + dictMapping.getExpression() + " error", e);
                }
            };
            return this.toString(textGetter);
        }

        public String toTextString() {
            return this.toString(DictMapping::getValue);
        }

        public String toValueString() {
            return this.toString((DictMapping mapping) -> String.valueOf(mapping.getValue()));
        }

        public DictMapping clone() {
            DictMapping clone = new DictMapping();
            clone.value = this.value;
            clone.key = this.key;
            clone.expression = this.expression;
            clone.expressionLanguage = this.expressionLanguage;
            if (this.children != null) {
                clone.children = this.children.stream().map(DictMapping::clone).collect(Collectors.toList());
            }
            return clone;
        }

        public void filterChildren(Predicate<DictMapping> mappingPredicate) {
            if (this.children != null) {
                this.children = this.children.stream().filter(mappingPredicate).collect(Collectors.toList());
                this.children.forEach(children -> children.filterChildren(mappingPredicate));
            }
        }
    }
}

