/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dictionary.simple;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.hswebframework.web.dictionary.api.DictionaryParser;
import org.hswebframework.web.dictionary.api.entity.DictionaryEntity;
import org.hswebframework.web.dictionary.api.entity.DictionaryItemEntity;
import org.hswebframework.web.dictionary.api.parser.SingleDictParser;
import org.hswebframework.web.dictionary.simple.parser.SimpleSingleDictParser;

public class SimpleDictionaryParser<V>
implements DictionaryParser<V> {
    private SingleDictParser toTextParser;
    private SingleDictParser toValueParser;
    private Map<String, String> toTextExpressions = new HashMap<String, String>();
    private Map<String, String> toValueExpressions = new HashMap<String, String>();

    public SimpleDictionaryParser<V> addToTextExpression(String id, String expression) {
        this.toTextExpressions.put(id, expression);
        return this;
    }

    public SimpleDictionaryParser<V> addToValueExpression(String id, String expression) {
        this.toValueExpressions.put(id, expression);
        return this;
    }

    public void setToTextExpressions(Map<String, String> toTextExpressions) {
        this.toTextExpressions = toTextExpressions;
    }

    public void setToValueExpressions(Map<String, String> toValueExpressions) {
        this.toValueExpressions = toValueExpressions;
    }

    public SingleDictParser getToTextParser() {
        return this.toTextParser;
    }

    public SingleDictParser getToValueParser() {
        return this.toValueParser;
    }

    public void setToTextParser(SingleDictParser toTextParser) {
        this.toTextParser = toTextParser;
    }

    public void setToValueParser(SingleDictParser toValueParser) {
        this.toValueParser = toValueParser;
    }

    public SimpleDictionaryParser<V> setDict(DictionaryEntity dict) {
        SimpleSingleDictParser toTextParser = new SimpleSingleDictParser();
        toTextParser.setDict(dict, DictionaryItemEntity::getValue, DictionaryItemEntity::getText, item -> this.toTextExpressions.get(item.getId()));
        SimpleSingleDictParser toValueParser = new SimpleSingleDictParser();
        toValueParser.setDict(dict, DictionaryItemEntity::getText, DictionaryItemEntity::getValue, item -> this.toValueExpressions.get(item.getId()));
        toValueParser.getTargetFormat().setSplitter(",");
        toValueParser.getTargetFormat().setChildStartChar(",");
        toValueParser.getTargetFormat().setChildEndChar("");
        toValueParser.getTargetFormat().setChildSplitter(",");
        this.setToTextParser(toTextParser);
        this.setToValueParser(toValueParser);
        return this;
    }

    public Optional<String> valueToText(V value, Object context) {
        if (value == null) {
            return Optional.empty();
        }
        return this.toTextParser.parse(String.valueOf(value), context);
    }

    public Optional<V> textToValue(String text, Object context) {
        return this.toValueParser.parse(text, context).map(v -> v);
    }
}

