/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dictionary.simple;

import java.util.ArrayList;
import java.util.List;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.utils.StringUtils;
import org.hswebframework.web.commons.entity.GenericEntity;
import org.hswebframework.web.commons.entity.TreeSortSupportEntity;
import org.hswebframework.web.dictionary.api.DictionaryItemService;
import org.hswebframework.web.dictionary.api.entity.DictionaryItemEntity;
import org.hswebframework.web.dictionary.api.events.ClearDictionaryCacheEvent;
import org.hswebframework.web.dictionary.simple.dao.DictionaryItemDao;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.service.AbstractTreeSortService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service(value="dictionaryItemService")
public class SimpleDictionaryItemService
extends AbstractTreeSortService<DictionaryItemEntity, String>
implements DictionaryItemService {
    @Autowired
    private DictionaryItemDao dictionaryItemDao;
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    protected IDGenerator<String> getIDGenerator() {
        return IDGenerator.MD5;
    }

    public DictionaryItemDao getDao() {
        return this.dictionaryItemDao;
    }

    public String insert(DictionaryItemEntity entity) {
        this.clearDictCache(entity.getDictId());
        return (String)super.insert((TreeSortSupportEntity)entity);
    }

    public int updateByPk(String id, DictionaryItemEntity entity) {
        this.clearDictCache(entity.getDictId());
        return super.updateByPk((Object)id, (GenericEntity)entity);
    }

    public DictionaryItemEntity deleteByPk(String id) {
        DictionaryItemEntity entity = (DictionaryItemEntity)this.selectByPk(id);
        if (null != entity) {
            this.clearDictCache(entity.getDictId());
        }
        return (DictionaryItemEntity)super.deleteByPk((Object)id);
    }

    public List<DictionaryItemEntity> selectByDictId(String dictId) {
        if (StringUtils.isNullOrEmpty((Object)dictId)) {
            return new ArrayList<DictionaryItemEntity>();
        }
        return ((Query)this.createQuery().where("dictId", (Object)dictId)).orderByAsc("sortIndex").listNoPaging();
    }

    private void clearDictCache(String dictId) {
        this.eventPublisher.publishEvent((Object)new ClearDictionaryCacheEvent(dictId));
    }
}

