/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dev.tools.web;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.controller.message.ResponseMessage;
import org.hswebframework.web.dev.tools.reader.FileInfo;
import org.hswebframework.web.dev.tools.writer.CodeWriter;
import org.hswebframework.web.dev.tools.writer.GeneratedCode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dev/tools/file"})
@Authorize(permission={"dev-tools"}, description={"\u5f00\u53d1\u4eba\u5458\u5de5\u5177-\u6587\u4ef6\u7ba1\u7406"})
@Api(tags={"\u5f00\u53d1\u4eba\u5458\u5de5\u5177-\u6587\u4ef6\u7ba1\u7406"}, value="\u5f00\u53d1\u4eba\u5458\u5de5\u5177-\u6587\u4ef6\u7ba1\u7406")
public class FileManagerDevToolsController {
    @Autowired
    private CodeWriter codeWriter;

    @PostMapping(value={"/write"})
    @ApiOperation(value="\u5199\u51fa\u6587\u4ef6")
    @Authorize(action={"write"}, description={"\u5199\u51fa\u6587\u4ef6"})
    public ResponseMessage<String> write(@RequestBody List<GeneratedCode> codes) {
        return ResponseMessage.ok((Object)this.codeWriter.write(codes));
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u83b7\u53d6\u76ee\u5f55\u4e0b\u7684\u5168\u90e8\u6587\u4ef6,\u4e0d\u5305\u542b\u5b50\u76ee\u5f55")
    @Authorize(action={"read"}, description={"\u8bfb\u53d6\u6587\u4ef6"})
    public ResponseMessage<List<FileInfo>> write(@RequestParam String path) {
        File[] files;
        File file = new File(path);
        if (!file.exists()) {
            return ResponseMessage.error((int)404, (String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        List<FileInfo> list = file.isDirectory() ? ((files = file.listFiles()) == null ? new ArrayList<FileInfo>() : Stream.of(files).map(FileInfo::from).collect(Collectors.toList())) : Collections.singletonList(FileInfo.from(file));
        return ResponseMessage.ok(list);
    }

    @GetMapping(value={"/read"})
    @ApiOperation(value="\u8bfb\u53d6\u6587\u672c\u6587\u4ef6\u5185\u5bb9")
    @Authorize(action={"read"}, description={"\u8bfb\u53d6\u6587\u4ef6"})
    public ResponseMessage<String> read(@RequestParam String file) {
        File fileInfo = new File(file);
        if (!fileInfo.exists()) {
            return ResponseMessage.error((int)404, (String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        if (fileInfo.length() > 0x80000000L) {
            return ResponseMessage.error((int)500, (String)"\u6587\u4ef6\u8fc7\u5927,\u65e0\u6cd5\u8bfb\u53d6");
        }
        List<String> list = Files.readAllLines(Paths.get(file, new String[0]));
        StringJoiner joiner = new StringJoiner("\n");
        list.forEach(joiner::add);
        return ResponseMessage.ok((Object)joiner.toString());
    }
}

