/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dev.tools.writer;

import java.io.File;
import java.util.List;
import org.hswebframework.utils.file.FileUtils;
import org.hswebframework.web.dev.tools.writer.ClassWriter;
import org.hswebframework.web.dev.tools.writer.CodeWriter;
import org.hswebframework.web.dev.tools.writer.GeneratedCode;
import org.springframework.beans.factory.annotation.Value;

public class DefaultCodeWriter
implements CodeWriter {
    @Value(value="${hsweb.dev.workspace:./}")
    private String workspace = "./";

    private void writeCode(String path, GeneratedCode code) {
        File file = new File(path);
        file.mkdir();
        String type = code.getType();
        String filePath = path + "/" + code.getFile();
        if ("dir".equals(type)) {
            code.getChildren().forEach(childrenCode -> this.writeCode(filePath, (GeneratedCode)childrenCode));
        } else if ("file".equals(type)) {
            String template = code.getTemplate();
            String fileName = filePath;
            String replaceMod = code.getRepeat();
            File codeFile = new File(fileName);
            if (codeFile.exists() && replaceMod != null && !fileName.endsWith(".java")) {
                switch (replaceMod) {
                    case "ignore": {
                        return;
                    }
                    case "append": {
                        String old = FileUtils.reader2String((String)fileName);
                        template = old + template;
                        break;
                    }
                }
            }
            if (fileName.endsWith(".java")) {
                ClassWriter.writeClass(fileName, template);
            } else {
                FileUtils.writeString2File((String)template, (String)fileName, (String)"utf-8");
            }
        }
    }

    @Override
    public String write(List<GeneratedCode> codes) {
        codes.forEach(code -> this.writeCode(this.workspace, (GeneratedCode)code));
        return this.workspace;
    }
}

