/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dev.tools.writer;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;
import java.io.File;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hswebframework.utils.file.FileUtils;

public class ClassWriter {
    public static void writeClass(String file, String code) {
        File oldClassFile = new File(file);
        if (oldClassFile.exists()) {
            CompilationUnit old = JavaParser.parse((File)oldClassFile);
            CompilationUnit newClazz = JavaParser.parse((String)code);
            Map oldFields = old.findAll(FieldDeclaration.class).stream().collect(Collectors.toMap(declaration -> declaration.getVariable(0).getNameAsString(), Function.identity()));
            Map oldMethod = old.findAll(MethodDeclaration.class).stream().collect(Collectors.toMap(NodeWithSimpleName::getNameAsString, Function.identity()));
            newClazz.findAll(FieldDeclaration.class).forEach(declaration -> {
                String name = declaration.getVariable(0).getNameAsString();
                if (oldFields.get(name) == null) {
                    VariableDeclarator declarator = declaration.getVariable(0);
                    FieldDeclaration newField = old.getType(0).addField(declarator.getType(), declarator.getNameAsString(), declaration.getModifiers().toArray(new Modifier[0]));
                    declaration.getJavadocComment().ifPresent(arg_0 -> ((FieldDeclaration)newField).setJavadocComment(arg_0));
                    for (Comment comment : declaration.getAllContainedComments()) {
                        newField.setComment(comment);
                    }
                    for (AnnotationExpr annotationExpr : declaration.getAnnotations()) {
                        newField.addAnnotation(annotationExpr.clone());
                    }
                }
            });
            newClazz.findAll(MethodDeclaration.class).forEach(declaration -> {
                String name = declaration.getNameAsString();
                if (oldMethod.get(name) == null) {
                    MethodDeclaration newMethod = old.getType(0).addMethod(name, declaration.getModifiers().toArray(new Modifier[0]));
                    declaration.getJavadocComment().ifPresent(arg_0 -> ((MethodDeclaration)newMethod).setJavadocComment(arg_0));
                    for (Comment comment : declaration.getAllContainedComments()) {
                        newMethod.setComment(comment);
                    }
                    for (AnnotationExpr annotationExpr : declaration.getAnnotations()) {
                        newMethod.addAnnotation(annotationExpr.clone());
                    }
                }
            });
            code = old.toString();
        }
        FileUtils.writeString2File((String)code, (String)file, (String)"utf-8");
    }
}

