/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.datasource.starter;

import javax.sql.DataSource;
import org.hswebframework.web.datasource.DynamicDataSource;
import org.hswebframework.web.datasource.DynamicDataSourceAutoConfiguration;
import org.hswebframework.web.datasource.DynamicDataSourceProxy;
import org.hswebframework.web.datasource.DynamicDataSourceService;
import org.hswebframework.web.datasource.config.DynamicDataSourceConfigRepository;
import org.hswebframework.web.datasource.jta.JtaDynamicDataSourceService;
import org.hswebframework.web.service.datasource.DataSourceConfigService;
import org.hswebframework.web.service.datasource.simple.InDBDataSourceRepository;
import org.hswebframework.web.service.datasource.simple.InDBDynamicDataSourceService;
import org.hswebframework.web.service.datasource.simple.InDBJtaDynamicDataSourceService;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@ComponentScan(value={"org.hswebframework.web.service.datasource.simple", "org.hswebframework.web.controller.datasource"})
@AutoConfigureBefore(value={DynamicDataSourceAutoConfiguration.class}, name={"org.hswebframework.web.datasource.jta.AtomikosDataSourceAutoConfiguration"})
public class InDBDynamicDataSourceAutoConfiguration {
    @Bean
    @Primary
    public DynamicDataSourceConfigRepository inDBDataSourceRepository(DataSourceConfigService dataSourceConfigService) {
        return new InDBDataSourceRepository(dataSourceConfigService);
    }

    @Bean
    @ConditionalOnMissingClass(value={"org.hswebframework.web.datasource.jta.JtaDynamicDataSourceService"})
    public DynamicDataSourceService inDBDynamicDataSourceService(DynamicDataSourceConfigRepository repository, DataSource dataSource) {
        return new InDBDynamicDataSourceService(repository, (DynamicDataSource)new DynamicDataSourceProxy("dataSource", dataSource));
    }

    @Configuration
    @ConditionalOnClass(value={JtaDynamicDataSourceService.class})
    public static class InDBJtaDynamicDataSourceServiceAutoConfiguration {
        @Bean
        public DynamicDataSourceService inDBJtaDynamicDataSourceService(DynamicDataSourceConfigRepository repository, DataSource dataSource) {
            return new InDBJtaDynamicDataSourceService(repository, (DynamicDataSource)new DynamicDataSourceProxy("dataSource", dataSource));
        }
    }
}

