/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.datasource.simple;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.datasource.config.DynamicDataSourceConfigRepository;
import org.hswebframework.web.entity.datasource.DataSourceConfigEntity;
import org.hswebframework.web.service.datasource.DataSourceConfigService;
import org.hswebframework.web.service.datasource.simple.InDBDynamicDataSourceConfig;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.NOT_SUPPORTED)
public class InDBDataSourceRepository
implements DynamicDataSourceConfigRepository<InDBDynamicDataSourceConfig> {
    private DataSourceConfigService dataSourceConfigService;

    public InDBDataSourceRepository(DataSourceConfigService dataSourceConfigService) {
        this.dataSourceConfigService = dataSourceConfigService;
    }

    public InDBDataSourceRepository() {
    }

    public void setDataSourceConfigService(DataSourceConfigService dataSourceConfigService) {
        this.dataSourceConfigService = dataSourceConfigService;
    }

    protected InDBDynamicDataSourceConfig convert(DataSourceConfigEntity entity) {
        if (null == entity) {
            return null;
        }
        Map config = entity.getProperties();
        if (config == null) {
            return null;
        }
        InDBDynamicDataSourceConfig target = (InDBDynamicDataSourceConfig)((Object)FastBeanCopier.copy((Object)config, InDBDynamicDataSourceConfig::new, (String[])new String[0]));
        target.setId((String)entity.getId());
        target.setName(entity.getName());
        target.setDescribe(entity.getDescribe());
        target.setProperties(config);
        return target;
    }

    public List<InDBDynamicDataSourceConfig> findAll() {
        return this.dataSourceConfigService.select().stream().map(this::convert).collect(Collectors.toList());
    }

    public InDBDynamicDataSourceConfig findById(String dataSourceId) {
        return this.convert((DataSourceConfigEntity)this.dataSourceConfigService.selectByPk((Object)dataSourceId));
    }

    public InDBDynamicDataSourceConfig add(InDBDynamicDataSourceConfig config) {
        throw new UnsupportedOperationException("add AtomikosDataSourceConfig not support");
    }

    public InDBDynamicDataSourceConfig remove(String dataSourceId) {
        throw new UnsupportedOperationException("remove datasource not support");
    }
}

