/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.datasource.simple;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.datasource.DatabaseType;
import org.hswebframework.web.datasource.DynamicDataSource;
import org.hswebframework.web.datasource.config.DynamicDataSourceConfigRepository;
import org.hswebframework.web.datasource.jta.AtomikosDataSourceConfig;
import org.hswebframework.web.datasource.jta.JtaDynamicDataSourceService;
import org.hswebframework.web.service.datasource.simple.InDBDynamicDataSourceConfig;

public class InDBJtaDynamicDataSourceService
extends JtaDynamicDataSourceService {
    static AtomikosDataSourceConfig convert(final InDBDynamicDataSourceConfig entity) {
        if (null == entity) {
            return null;
        }
        Map<String, Object> config = entity.getProperties();
        if (config == null) {
            return null;
        }
        Properties xaProperties = new Properties();
        for (Map.Entry<String, Object> entry : config.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith("xaProperties.")) continue;
            xaProperties.put(key.substring("xaProperties.".length()), entry.getValue());
        }
        AtomikosDataSourceConfig target = (AtomikosDataSourceConfig)FastBeanCopier.copy(config, (Object)new AtomikosDataSourceConfig(){
            private static final long serialVersionUID = -2704649332301331803L;

            public int hashCode() {
                return entity.hashCode();
            }

            public boolean equals(Object o) {
                return o instanceof AtomikosDataSourceConfig && this.hashCode() == o.hashCode();
            }
        }, (String[])new String[0]);
        target.setId(entity.getId());
        target.setName(entity.getName());
        target.setDescribe(entity.getDescribe());
        target.setXaProperties(xaProperties);
        target.setDatabaseType((DatabaseType)Optional.ofNullable(config.get("databaseType")).map(String::valueOf).map(DatabaseType::valueOf).orElse(null));
        return target;
    }

    public InDBJtaDynamicDataSourceService(final DynamicDataSourceConfigRepository<InDBDynamicDataSourceConfig> repository, DynamicDataSource defaultDataSource) {
        super((DynamicDataSourceConfigRepository)new DynamicDataSourceConfigRepository<AtomikosDataSourceConfig>(){

            public List<AtomikosDataSourceConfig> findAll() {
                return repository.findAll().stream().map(InDBJtaDynamicDataSourceService::convert).filter(Objects::nonNull).collect(Collectors.toList());
            }

            public AtomikosDataSourceConfig findById(String dataSourceId) {
                return InDBJtaDynamicDataSourceService.convert((InDBDynamicDataSourceConfig)repository.findById(dataSourceId));
            }

            public AtomikosDataSourceConfig add(AtomikosDataSourceConfig config) {
                throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u6dfb\u52a0\u6570\u636e\u6e90\u914d\u7f6e");
            }

            public AtomikosDataSourceConfig remove(String dataSourceId) {
                throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u5220\u9664\u6570\u636e\u6e90\u914d\u7f6e");
            }
        }, defaultDataSource);
    }
}

