/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.database.manager.web;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hswebframework.web.Sqls;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.controller.message.ResponseMessage;
import org.hswebframework.web.database.manager.DatabaseManagerService;
import org.hswebframework.web.database.manager.SqlExecuteRequest;
import org.hswebframework.web.database.manager.SqlExecuteResult;
import org.hswebframework.web.database.manager.SqlInfo;
import org.hswebframework.web.database.manager.meta.ObjectMetadata;
import org.hswebframework.web.database.manager.sql.TransactionInfo;
import org.hswebframework.web.datasource.DataSourceHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/database/manager"})
@Api(tags={"\u5f00\u53d1\u4eba\u5458\u5de5\u5177-\u6570\u636e\u5e93\u7ef4\u62a4"}, value="\u6570\u636e\u5e93\u7ef4\u62a4")
@Authorize(permission={"database-manager"}, description={"\u6570\u636e\u5e93\u7ef4\u62a4"})
public class DataBaseManagerController {
    @Autowired
    private DatabaseManagerService databaseManagerService;

    @GetMapping(value={"/metas"})
    @Authorize(action={"query"}, description={"\u83b7\u53d6\u5143\u6570\u636e"})
    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u5e93\u5143\u6570\u636e")
    public ResponseMessage<Map<ObjectMetadata.ObjectType, List<? extends ObjectMetadata>>> parseAllObject() throws Exception {
        return this.parseAllObject(null);
    }

    @GetMapping(value={"/metas/{datasourceId}"})
    @Authorize(action={"query"}, description={"\u83b7\u53d6\u5143\u6570\u636e"})
    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u6570\u636e\u6e90\u7684\u5143\u6570\u636e")
    public ResponseMessage<Map<ObjectMetadata.ObjectType, List<? extends ObjectMetadata>>> parseAllObject(@PathVariable @ApiParam(value="\u6570\u636e\u6e90ID") String datasourceId) throws Exception {
        DataSourceHolder.switcher().use(datasourceId);
        return ResponseMessage.ok((Object)this.databaseManagerService.getMetas());
    }

    @PostMapping(value={"/execute/{datasourceId}"}, consumes={"text/plain"})
    @Authorize(action={"execute"}, description={"\u6267\u884cSQL"})
    @ApiOperation(value="\u6307\u5b9a\u6570\u636e\u6e90\u6267\u884cSQL")
    public ResponseMessage<List<SqlExecuteResult>> execute(@PathVariable @ApiParam(value="\u6570\u636e\u6e90ID") String datasourceId, @RequestBody @ApiParam(value="SQL\u811a\u672c") String sqlLines) throws Exception {
        DataSourceHolder.switcher().use(datasourceId);
        return ResponseMessage.ok((Object)this.databaseManagerService.execute(SqlExecuteRequest.builder().sql(this.parseSql(sqlLines, datasourceId)).build()));
    }

    @PostMapping(value={"/execute"}, consumes={"text/plain"})
    @ApiOperation(value="\u6267\u884cSQL")
    @Authorize(action={"execute"}, description={"\u6267\u884cSQL"})
    public ResponseMessage<List<SqlExecuteResult>> execute(@RequestBody @ApiParam(value="SQL\u811a\u672c") String sqlLines) throws Exception {
        return ResponseMessage.ok((Object)this.databaseManagerService.execute(SqlExecuteRequest.builder().sql(this.parseSql(sqlLines, null)).build()));
    }

    @PostMapping(value={"/transactional/execute/{transactionalId}"}, consumes={"text/plain"})
    @Authorize(action={"execute"}, description={"\u6267\u884cSQL"})
    @ApiOperation(value="\u5f00\u542f\u4e8b\u52a1\u6267\u884cSQL")
    public ResponseMessage<List<SqlExecuteResult>> executeTransactional(@PathVariable @ApiParam(value="\u4e8b\u52a1ID") String transactionalId, @ApiParam(value="SQL\u811a\u672c") @RequestBody String sqlLines) throws Exception {
        return ResponseMessage.ok((Object)this.databaseManagerService.execute(transactionalId, SqlExecuteRequest.builder().sql(this.parseSql(sqlLines, null)).build()));
    }

    @PostMapping(value={"/transactional/execute/{transactionalId}/{dataSourceId}"}, consumes={"text/plain"})
    @Authorize(action={"execute"}, description={"\u6267\u884cSQL"})
    @ApiOperation(value="\u5f00\u542f\u4e8b\u52a1\u6267\u884c\u6307\u5b9a\u6570\u636e\u6e90\u5bf9SQL")
    public ResponseMessage<List<SqlExecuteResult>> executeTransactional(@PathVariable @ApiParam(value="\u4e8b\u52a1ID") String transactionalId, @PathVariable @ApiParam(value="\u6570\u636e\u6e90ID") String dataSourceId, @ApiParam(value="SQL\u811a\u672c") @RequestBody String sqlLines) throws Exception {
        DataSourceHolder.switcher().use(dataSourceId);
        return ResponseMessage.ok((Object)this.databaseManagerService.execute(transactionalId, SqlExecuteRequest.builder().sql(this.parseSql(sqlLines, dataSourceId)).build()));
    }

    @GetMapping(value={"/transactional/new"})
    @Authorize(action={"execute"}, description={"\u6267\u884cSQL"})
    @ApiOperation(value="\u65b0\u5efa\u4e8b\u52a1")
    public ResponseMessage<String> newTransaction() throws Exception {
        return ResponseMessage.ok((Object)this.databaseManagerService.newTransaction());
    }

    @GetMapping(value={"/transactional/new/{dataSourceId}"})
    @Authorize(action={"execute"}, description={"\u6267\u884cSQL"})
    @ApiOperation(value="\u6307\u5b9a\u6570\u636e\u6e90\u65b0\u5efa\u4e8b\u52a1")
    public ResponseMessage<String> newTransaction(@PathVariable String dataSourceId) throws Exception {
        DataSourceHolder.switcher().use(dataSourceId);
        return ResponseMessage.ok((Object)this.databaseManagerService.newTransaction(dataSourceId));
    }

    @GetMapping(value={"/transactional"})
    @Authorize(action={"execute"}, description={"\u6267\u884cSQL"})
    @ApiOperation(value="\u83b7\u53d6\u5168\u90e8\u4e8b\u52a1\u4fe1\u606f")
    public ResponseMessage<List<TransactionInfo>> allTransaction() throws Exception {
        return ResponseMessage.ok((Object)this.databaseManagerService.allTransaction());
    }

    @PostMapping(value={"/transactional/{id}/commit"})
    @Authorize(action={"execute"}, description={"\u6267\u884cSQL"})
    @ApiOperation(value="\u63d0\u4ea4\u4e8b\u52a1")
    public ResponseMessage<String> commitTransaction(@PathVariable String id) throws Exception {
        this.databaseManagerService.commit(id);
        return ResponseMessage.ok();
    }

    @PostMapping(value={"/transactional/{id}/rollback"})
    @Authorize(action={"execute"}, description={"\u6267\u884cSQL"})
    @ApiOperation(value="\u56de\u6eda\u4e8b\u52a1")
    public ResponseMessage<String> rollbackTransaction(@PathVariable String id) throws Exception {
        this.databaseManagerService.rollback(id);
        return ResponseMessage.ok();
    }

    private List<SqlInfo> parseSql(String sqlText, String datasourceId) {
        List sqlList = Sqls.parse((String)sqlText);
        return sqlList.stream().map(sql -> {
            SqlInfo sqlInfo = new SqlInfo();
            sqlInfo.setSql(sql);
            sqlInfo.setDatasourceId(datasourceId);
            sqlInfo.setType(sql.split("[ ]")[0].toLowerCase());
            return sqlInfo;
        }).collect(Collectors.toList());
    }
}

