/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.database.manager.meta.table.parser;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.hswebframework.ezorm.core.ObjectWrapper;
import org.hswebframework.ezorm.rdb.executor.SqlExecutor;
import org.hswebframework.web.database.manager.meta.table.ColumnMetadata;
import org.hswebframework.web.database.manager.meta.table.TableMetadata;
import org.hswebframework.web.database.manager.meta.table.parser.MetaDataParser;
import org.hswebframework.web.database.manager.meta.table.parser.MetaDataParserSupplier;
import org.hswebframework.web.database.manager.meta.table.parser.TableMetaDataParser;
import org.hswebframework.web.datasource.DataSourceHolder;
import org.hswebframework.web.datasource.DatabaseType;

public abstract class AbstractSqlTableMetaDataParser
implements TableMetaDataParser,
MetaDataParserSupplier {
    private SqlExecutor sqlExecutor;
    private static ColumnMetadataWrapper wrapper = new ColumnMetadataWrapper();
    private Set<DatabaseType> supportDataBases = new HashSet<DatabaseType>();

    public abstract String getSelectTableColumnsSql();

    public abstract String getSelectTableMetaSql();

    public abstract String getSelectAllTableSql();

    public AbstractSqlTableMetaDataParser(SqlExecutor sqlExecutor, DatabaseType ... databaseTypes) {
        this.sqlExecutor = sqlExecutor;
        this.supportDataBases.addAll(Arrays.asList(databaseTypes));
    }

    @Override
    public boolean isSupport(DatabaseType type) {
        return this.supportDataBases.contains(type);
    }

    public MetaDataParser get() {
        return this;
    }

    @Override
    public List<TableMetadata> parseAll() throws SQLException {
        String dsId = DataSourceHolder.switcher().currentDataSourceId();
        return this.sqlExecutor.list(this.getSelectAllTableSql()).parallelStream().map(map -> map.get("name")).map(String::valueOf).map(tableName -> {
            try {
                DataSourceHolder.switcher().use(dsId);
                TableMetadata tableMetadata = this.parse((String)tableName);
                return tableMetadata;
            }
            finally {
                DataSourceHolder.switcher().reset();
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public TableMetadata parse(String objectName) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("table", objectName);
        Map tableMetaMap = this.sqlExecutor.single(this.getSelectTableMetaSql(), param);
        if (tableMetaMap == null) {
            return null;
        }
        TableMetadata table = new TableMetadata();
        table.setName(objectName);
        table.setComment(tableMetaMap.getOrDefault("comment", ""));
        List columns = this.sqlExecutor.list(this.getSelectTableColumnsSql(), param, (ObjectWrapper)wrapper);
        table.setColumns(columns);
        return table;
    }

    static class ColumnMetadataWrapper
    implements ObjectWrapper<ColumnMetadata> {
        static Map<String, BiConsumer<ColumnMetadata, Object>> propertySetters = new HashMap<String, BiConsumer<ColumnMetadata, Object>>();

        ColumnMetadataWrapper() {
        }

        public Class<ColumnMetadata> getType() {
            return ColumnMetadata.class;
        }

        public ColumnMetadata newInstance() {
            return new ColumnMetadata();
        }

        public void wrapper(ColumnMetadata instance, int index, String attr, Object value) {
            try {
                BeanUtilsBean.getInstance().setProperty((Object)instance, attr, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public boolean done(ColumnMetadata instance) {
            return true;
        }

        static {
            propertySetters.put("name", (columnMetadata, value) -> columnMetadata.setName(String.valueOf(value)));
        }
    }
}

