/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.controller.dashboard;

import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.AuthenticationPredicate;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.commons.entity.DataStatus;
import org.hswebframework.web.controller.dashboard.model.UserDashBoardResponse;
import org.hswebframework.web.controller.message.ResponseMessage;
import org.hswebframework.web.dashboard.DashBoardService;
import org.hswebframework.web.entity.authorization.UserSettingEntity;
import org.hswebframework.web.service.authorization.UserSettingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dashboard-user"})
@Api(tags={"\u4eea\u8868\u76d8-\u7528\u6237\u914d\u7f6e"}, value="\u4eea\u8868\u76d8\u7528\u6237\u914d\u7f6e")
@Authorize
public class DashBoardUserConfigController {
    @Autowired
    private UserSettingService userSettingService;
    @Autowired
    private DashBoardService dashBoardService;

    @GetMapping(value={"/all"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u53ef\u9009\u62e9\u7684\u4eea\u8868\u76d8\u914d\u7f6e")
    public ResponseMessage<List<UserDashBoardResponse>> getUserAllDashBoardConfig(Authentication authentication) {
        List configList = this.dashBoardService.select().stream().filter(Objects::nonNull).filter(config -> DataStatus.STATUS_ENABLED.equals(config.getStatus())).filter(config -> StringUtils.isEmpty((Object)config) || AuthenticationPredicate.has((String)config.getPermission()).test((Object)authentication)).map(config -> (UserDashBoardResponse)config.copyTo((Object)new UserDashBoardResponse(), new String[0])).collect(Collectors.toList());
        return ResponseMessage.ok(configList);
    }

    @GetMapping
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u81ea\u5b9a\u4e49\u7684\u4eea\u8868\u76d8\u914d\u7f6e")
    public ResponseMessage<List<UserDashBoardResponse>> getUserConfigDashBoardConfig(Authentication authentication) {
        List configs;
        UserSettingEntity settingEntity = this.userSettingService.selectByUser(authentication.getUser().getId(), "dashboard-config", "current");
        if (settingEntity == null) {
            configs = this.dashBoardService.selectAllDefaults();
            Collections.sort(configs);
        } else {
            List ids = JSON.parseArray((String)settingEntity.getSetting(), String.class);
            configs = this.dashBoardService.selectByPk(ids);
            configs.sort(Comparator.comparing(conf -> ids.indexOf(conf.getId())));
        }
        List configList = configs.stream().filter(config -> DataStatus.STATUS_ENABLED.equals(config.getStatus()) && (!StringUtils.hasText((String)config.getPermission()) || AuthenticationPredicate.has((String)config.getPermission()).test((Object)authentication))).map(config -> (UserDashBoardResponse)config.copyTo((Object)new UserDashBoardResponse(), new String[0])).collect(Collectors.toList());
        return ResponseMessage.ok(configList);
    }

    @PutMapping
    @ApiOperation(value="\u4fdd\u5b58\u7528\u6237\u81ea\u5b9a\u4e49\u7684\u4eea\u8868\u76d8\u914d\u7f6e")
    public ResponseMessage<Void> saveUserDashBoardConfig(@RequestBody List<String> configIdList, Authentication authentication) {
        UserSettingEntity settingEntity = this.userSettingService.selectByUser(authentication.getUser().getId(), "dashboard-config", "current");
        if (settingEntity == null) {
            settingEntity = (UserSettingEntity)this.userSettingService.createEntity();
            settingEntity.setUserId(authentication.getUser().getId());
            settingEntity.setKey("dashboard-config");
            settingEntity.setSettingId("current");
        }
        settingEntity.setSetting(JSON.toJSONString(configIdList));
        this.userSettingService.saveOrUpdate((Object)settingEntity);
        return ResponseMessage.ok();
    }
}

