/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.config.simple;

import java.util.Optional;
import org.hswebframework.web.dao.config.ConfigDao;
import org.hswebframework.web.entity.config.ConfigContent;
import org.hswebframework.web.entity.config.ConfigEntity;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.service.EnableCacheAllEvictGenericEntityService;
import org.hswebframework.web.service.config.ConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="configService")
@CacheConfig(cacheNames={"hsweb-config"})
public class SimpleConfigService
extends EnableCacheAllEvictGenericEntityService<ConfigEntity, String>
implements ConfigService {
    @Autowired
    private ConfigDao configDao;

    protected IDGenerator<String> getIDGenerator() {
        return IDGenerator.MD5;
    }

    public ConfigDao getDao() {
        return this.configDao;
    }

    protected Optional<ConfigContent> getConfigContent(String configId, String key) {
        ConfigEntity entity = (ConfigEntity)this.selectByPk(configId);
        if (entity == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(entity.get(key));
    }

    @Cacheable(key="'id:'+#configId+'.'+#key+'-as-number'")
    public Number getNumber(String configId, String key, Number defaultValue) {
        return this.getConfigContent(configId, key).map(conf -> conf.getNumber(defaultValue)).orElse(defaultValue);
    }

    @Cacheable(key="'id:'+#configId+'.'+#key+'-as-string'")
    public String getString(String configId, String key, String defaultValue) {
        return this.getConfigContent(configId, key).map(conf -> conf.getValue((Object)defaultValue)).map(String::valueOf).orElse(defaultValue);
    }

    @Cacheable(key="'id:'+#configId+'.'+#key+'-as-boolean'")
    public boolean getBoolean(String configId, String key, boolean defaultValue) {
        return this.getConfigContent(configId, key).map(conf -> conf.getValue((Object)defaultValue)).map(val -> Boolean.TRUE.equals(val) || Integer.valueOf(1).equals(val)).orElse(defaultValue);
    }
}

